/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.virtual.currency.bitcoin.model.blockchain;

import cn.hutool.http.HttpRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.math.BigInteger;
import java.util.List;
import live.lingting.virtual.currency.core.Endpoints;
import live.lingting.virtual.currency.core.util.JacksonUtils;

public class RawTransaction {
    private String response;
    private String reason;
    private String code;
    private String uuid;
    @JsonProperty(value="ver")
    private Integer ver;
    @JsonProperty(value="weight")
    private BigInteger weight;
    @JsonProperty(value="block_height")
    private BigInteger blockHeight;
    @JsonProperty(value="relayed_by")
    private String relayedBy;
    @JsonProperty(value="lock_time")
    private Long lockTime;
    @JsonProperty(value="size")
    private BigInteger size;
    @JsonProperty(value="block_index")
    private BigInteger blockIndex;
    @JsonProperty(value="time")
    private Long time;
    @JsonProperty(value="tx_index")
    private Long txIndex;
    @JsonProperty(value="vin_sz")
    private Integer vinSz;
    @JsonProperty(value="hash")
    private String hash;
    @JsonProperty(value="vout_sz")
    private Integer voutSz;
    @JsonProperty(value="inputs")
    private List<In> ins;
    @JsonProperty(value="out")
    private List<Out> outs;

    public static RawTransaction of(Endpoints endpoints, String txId) throws JsonProcessingException {
        HttpRequest request = HttpRequest.get((String)endpoints.getHttpUrl("rawtx/" + txId));
        String response = request.execute().body();
        return ((RawTransaction)JacksonUtils.toObj((String)response, RawTransaction.class)).setResponse(response);
    }

    public String getResponse() {
        return this.response;
    }

    public String getReason() {
        return this.reason;
    }

    public String getCode() {
        return this.code;
    }

    public String getUuid() {
        return this.uuid;
    }

    public Integer getVer() {
        return this.ver;
    }

    public BigInteger getWeight() {
        return this.weight;
    }

    public BigInteger getBlockHeight() {
        return this.blockHeight;
    }

    public String getRelayedBy() {
        return this.relayedBy;
    }

    public Long getLockTime() {
        return this.lockTime;
    }

    public BigInteger getSize() {
        return this.size;
    }

    public BigInteger getBlockIndex() {
        return this.blockIndex;
    }

    public Long getTime() {
        return this.time;
    }

    public Long getTxIndex() {
        return this.txIndex;
    }

    public Integer getVinSz() {
        return this.vinSz;
    }

    public String getHash() {
        return this.hash;
    }

    public Integer getVoutSz() {
        return this.voutSz;
    }

    public List<In> getIns() {
        return this.ins;
    }

    public List<Out> getOuts() {
        return this.outs;
    }

    public RawTransaction setResponse(String response) {
        this.response = response;
        return this;
    }

    public RawTransaction setReason(String reason) {
        this.reason = reason;
        return this;
    }

    public RawTransaction setCode(String code) {
        this.code = code;
        return this;
    }

    public RawTransaction setUuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @JsonProperty(value="ver")
    public RawTransaction setVer(Integer ver) {
        this.ver = ver;
        return this;
    }

    @JsonProperty(value="weight")
    public RawTransaction setWeight(BigInteger weight) {
        this.weight = weight;
        return this;
    }

    @JsonProperty(value="block_height")
    public RawTransaction setBlockHeight(BigInteger blockHeight) {
        this.blockHeight = blockHeight;
        return this;
    }

    @JsonProperty(value="relayed_by")
    public RawTransaction setRelayedBy(String relayedBy) {
        this.relayedBy = relayedBy;
        return this;
    }

    @JsonProperty(value="lock_time")
    public RawTransaction setLockTime(Long lockTime) {
        this.lockTime = lockTime;
        return this;
    }

    @JsonProperty(value="size")
    public RawTransaction setSize(BigInteger size) {
        this.size = size;
        return this;
    }

    @JsonProperty(value="block_index")
    public RawTransaction setBlockIndex(BigInteger blockIndex) {
        this.blockIndex = blockIndex;
        return this;
    }

    @JsonProperty(value="time")
    public RawTransaction setTime(Long time) {
        this.time = time;
        return this;
    }

    @JsonProperty(value="tx_index")
    public RawTransaction setTxIndex(Long txIndex) {
        this.txIndex = txIndex;
        return this;
    }

    @JsonProperty(value="vin_sz")
    public RawTransaction setVinSz(Integer vinSz) {
        this.vinSz = vinSz;
        return this;
    }

    @JsonProperty(value="hash")
    public RawTransaction setHash(String hash) {
        this.hash = hash;
        return this;
    }

    @JsonProperty(value="vout_sz")
    public RawTransaction setVoutSz(Integer voutSz) {
        this.voutSz = voutSz;
        return this;
    }

    @JsonProperty(value="inputs")
    public RawTransaction setIns(List<In> ins) {
        this.ins = ins;
        return this;
    }

    @JsonProperty(value="out")
    public RawTransaction setOuts(List<Out> outs) {
        this.outs = outs;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawTransaction)) {
            return false;
        }
        RawTransaction other = (RawTransaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$response = this.getResponse();
        String other$response = other.getResponse();
        if (this$response == null ? other$response != null : !this$response.equals(other$response)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$uuid = this.getUuid();
        String other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !this$uuid.equals(other$uuid)) {
            return false;
        }
        Integer this$ver = this.getVer();
        Integer other$ver = other.getVer();
        if (this$ver == null ? other$ver != null : !((Object)this$ver).equals(other$ver)) {
            return false;
        }
        BigInteger this$weight = this.getWeight();
        BigInteger other$weight = other.getWeight();
        if (this$weight == null ? other$weight != null : !((Object)this$weight).equals(other$weight)) {
            return false;
        }
        BigInteger this$blockHeight = this.getBlockHeight();
        BigInteger other$blockHeight = other.getBlockHeight();
        if (this$blockHeight == null ? other$blockHeight != null : !((Object)this$blockHeight).equals(other$blockHeight)) {
            return false;
        }
        String this$relayedBy = this.getRelayedBy();
        String other$relayedBy = other.getRelayedBy();
        if (this$relayedBy == null ? other$relayedBy != null : !this$relayedBy.equals(other$relayedBy)) {
            return false;
        }
        Long this$lockTime = this.getLockTime();
        Long other$lockTime = other.getLockTime();
        if (this$lockTime == null ? other$lockTime != null : !((Object)this$lockTime).equals(other$lockTime)) {
            return false;
        }
        BigInteger this$size = this.getSize();
        BigInteger other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        BigInteger this$blockIndex = this.getBlockIndex();
        BigInteger other$blockIndex = other.getBlockIndex();
        if (this$blockIndex == null ? other$blockIndex != null : !((Object)this$blockIndex).equals(other$blockIndex)) {
            return false;
        }
        Long this$time = this.getTime();
        Long other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        Long this$txIndex = this.getTxIndex();
        Long other$txIndex = other.getTxIndex();
        if (this$txIndex == null ? other$txIndex != null : !((Object)this$txIndex).equals(other$txIndex)) {
            return false;
        }
        Integer this$vinSz = this.getVinSz();
        Integer other$vinSz = other.getVinSz();
        if (this$vinSz == null ? other$vinSz != null : !((Object)this$vinSz).equals(other$vinSz)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        Integer this$voutSz = this.getVoutSz();
        Integer other$voutSz = other.getVoutSz();
        if (this$voutSz == null ? other$voutSz != null : !((Object)this$voutSz).equals(other$voutSz)) {
            return false;
        }
        List<In> this$ins = this.getIns();
        List<In> other$ins = other.getIns();
        if (this$ins == null ? other$ins != null : !((Object)this$ins).equals(other$ins)) {
            return false;
        }
        List<Out> this$outs = this.getOuts();
        List<Out> other$outs = other.getOuts();
        return !(this$outs == null ? other$outs != null : !((Object)this$outs).equals(other$outs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RawTransaction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : $response.hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : $uuid.hashCode());
        Integer $ver = this.getVer();
        result = result * 59 + ($ver == null ? 43 : ((Object)$ver).hashCode());
        BigInteger $weight = this.getWeight();
        result = result * 59 + ($weight == null ? 43 : ((Object)$weight).hashCode());
        BigInteger $blockHeight = this.getBlockHeight();
        result = result * 59 + ($blockHeight == null ? 43 : ((Object)$blockHeight).hashCode());
        String $relayedBy = this.getRelayedBy();
        result = result * 59 + ($relayedBy == null ? 43 : $relayedBy.hashCode());
        Long $lockTime = this.getLockTime();
        result = result * 59 + ($lockTime == null ? 43 : ((Object)$lockTime).hashCode());
        BigInteger $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        BigInteger $blockIndex = this.getBlockIndex();
        result = result * 59 + ($blockIndex == null ? 43 : ((Object)$blockIndex).hashCode());
        Long $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        Long $txIndex = this.getTxIndex();
        result = result * 59 + ($txIndex == null ? 43 : ((Object)$txIndex).hashCode());
        Integer $vinSz = this.getVinSz();
        result = result * 59 + ($vinSz == null ? 43 : ((Object)$vinSz).hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        Integer $voutSz = this.getVoutSz();
        result = result * 59 + ($voutSz == null ? 43 : ((Object)$voutSz).hashCode());
        List<In> $ins = this.getIns();
        result = result * 59 + ($ins == null ? 43 : ((Object)$ins).hashCode());
        List<Out> $outs = this.getOuts();
        result = result * 59 + ($outs == null ? 43 : ((Object)$outs).hashCode());
        return result;
    }

    public String toString() {
        return "RawTransaction(response=" + this.getResponse() + ", reason=" + this.getReason() + ", code=" + this.getCode() + ", uuid=" + this.getUuid() + ", ver=" + this.getVer() + ", weight=" + this.getWeight() + ", blockHeight=" + this.getBlockHeight() + ", relayedBy=" + this.getRelayedBy() + ", lockTime=" + this.getLockTime() + ", size=" + this.getSize() + ", blockIndex=" + this.getBlockIndex() + ", time=" + this.getTime() + ", txIndex=" + this.getTxIndex() + ", vinSz=" + this.getVinSz() + ", hash=" + this.getHash() + ", voutSz=" + this.getVoutSz() + ", ins=" + this.getIns() + ", outs=" + this.getOuts() + ")";
    }

    public static class Out {
        @JsonProperty(value="spent")
        private Boolean spent;
        @JsonProperty(value="tx_index")
        private Long txIndex;
        @JsonProperty(value="type")
        private Long type;
        @JsonProperty(value="addr")
        private String addr;
        @JsonProperty(value="value")
        private BigInteger value;
        @JsonProperty(value="n")
        private Integer n;
        @JsonProperty(value="script")
        private String script;
        @JsonProperty(value="spending_outpoints")
        private List<SpendingOutpoint> spendingOutpoints;

        public Boolean getSpent() {
            return this.spent;
        }

        public Long getTxIndex() {
            return this.txIndex;
        }

        public Long getType() {
            return this.type;
        }

        public String getAddr() {
            return this.addr;
        }

        public BigInteger getValue() {
            return this.value;
        }

        public Integer getN() {
            return this.n;
        }

        public String getScript() {
            return this.script;
        }

        public List<SpendingOutpoint> getSpendingOutpoints() {
            return this.spendingOutpoints;
        }

        @JsonProperty(value="spent")
        public Out setSpent(Boolean spent) {
            this.spent = spent;
            return this;
        }

        @JsonProperty(value="tx_index")
        public Out setTxIndex(Long txIndex) {
            this.txIndex = txIndex;
            return this;
        }

        @JsonProperty(value="type")
        public Out setType(Long type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="addr")
        public Out setAddr(String addr) {
            this.addr = addr;
            return this;
        }

        @JsonProperty(value="value")
        public Out setValue(BigInteger value) {
            this.value = value;
            return this;
        }

        @JsonProperty(value="n")
        public Out setN(Integer n) {
            this.n = n;
            return this;
        }

        @JsonProperty(value="script")
        public Out setScript(String script) {
            this.script = script;
            return this;
        }

        @JsonProperty(value="spending_outpoints")
        public Out setSpendingOutpoints(List<SpendingOutpoint> spendingOutpoints) {
            this.spendingOutpoints = spendingOutpoints;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Out)) {
                return false;
            }
            Out other = (Out)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$spent = this.getSpent();
            Boolean other$spent = other.getSpent();
            if (this$spent == null ? other$spent != null : !((Object)this$spent).equals(other$spent)) {
                return false;
            }
            Long this$txIndex = this.getTxIndex();
            Long other$txIndex = other.getTxIndex();
            if (this$txIndex == null ? other$txIndex != null : !((Object)this$txIndex).equals(other$txIndex)) {
                return false;
            }
            Long this$type = this.getType();
            Long other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
                return false;
            }
            String this$addr = this.getAddr();
            String other$addr = other.getAddr();
            if (this$addr == null ? other$addr != null : !this$addr.equals(other$addr)) {
                return false;
            }
            BigInteger this$value = this.getValue();
            BigInteger other$value = other.getValue();
            if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
                return false;
            }
            Integer this$n = this.getN();
            Integer other$n = other.getN();
            if (this$n == null ? other$n != null : !((Object)this$n).equals(other$n)) {
                return false;
            }
            String this$script = this.getScript();
            String other$script = other.getScript();
            if (this$script == null ? other$script != null : !this$script.equals(other$script)) {
                return false;
            }
            List<SpendingOutpoint> this$spendingOutpoints = this.getSpendingOutpoints();
            List<SpendingOutpoint> other$spendingOutpoints = other.getSpendingOutpoints();
            return !(this$spendingOutpoints == null ? other$spendingOutpoints != null : !((Object)this$spendingOutpoints).equals(other$spendingOutpoints));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Out;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $spent = this.getSpent();
            result = result * 59 + ($spent == null ? 43 : ((Object)$spent).hashCode());
            Long $txIndex = this.getTxIndex();
            result = result * 59 + ($txIndex == null ? 43 : ((Object)$txIndex).hashCode());
            Long $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
            String $addr = this.getAddr();
            result = result * 59 + ($addr == null ? 43 : $addr.hashCode());
            BigInteger $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            Integer $n = this.getN();
            result = result * 59 + ($n == null ? 43 : ((Object)$n).hashCode());
            String $script = this.getScript();
            result = result * 59 + ($script == null ? 43 : $script.hashCode());
            List<SpendingOutpoint> $spendingOutpoints = this.getSpendingOutpoints();
            result = result * 59 + ($spendingOutpoints == null ? 43 : ((Object)$spendingOutpoints).hashCode());
            return result;
        }

        public String toString() {
            return "RawTransaction.Out(spent=" + this.getSpent() + ", txIndex=" + this.getTxIndex() + ", type=" + this.getType() + ", addr=" + this.getAddr() + ", value=" + this.getValue() + ", n=" + this.getN() + ", script=" + this.getScript() + ", spendingOutpoints=" + this.getSpendingOutpoints() + ")";
        }

        public static class SpendingOutpoint {
            @JsonProperty(value="tx_index")
            private Long txIndex;
            @JsonProperty(value="n")
            private Integer n;

            public Long getTxIndex() {
                return this.txIndex;
            }

            public Integer getN() {
                return this.n;
            }

            @JsonProperty(value="tx_index")
            public SpendingOutpoint setTxIndex(Long txIndex) {
                this.txIndex = txIndex;
                return this;
            }

            @JsonProperty(value="n")
            public SpendingOutpoint setN(Integer n) {
                this.n = n;
                return this;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SpendingOutpoint)) {
                    return false;
                }
                SpendingOutpoint other = (SpendingOutpoint)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$txIndex = this.getTxIndex();
                Long other$txIndex = other.getTxIndex();
                if (this$txIndex == null ? other$txIndex != null : !((Object)this$txIndex).equals(other$txIndex)) {
                    return false;
                }
                Integer this$n = this.getN();
                Integer other$n = other.getN();
                return !(this$n == null ? other$n != null : !((Object)this$n).equals(other$n));
            }

            protected boolean canEqual(Object other) {
                return other instanceof SpendingOutpoint;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $txIndex = this.getTxIndex();
                result = result * 59 + ($txIndex == null ? 43 : ((Object)$txIndex).hashCode());
                Integer $n = this.getN();
                result = result * 59 + ($n == null ? 43 : ((Object)$n).hashCode());
                return result;
            }

            public String toString() {
                return "RawTransaction.Out.SpendingOutpoint(txIndex=" + this.getTxIndex() + ", n=" + this.getN() + ")";
            }
        }
    }

    public static class In {
        @JsonProperty(value="sequence")
        private BigInteger sequence;
        @JsonProperty(value="witness")
        private String witness;
        @JsonProperty(value="prev_out")
        private Out prevOut;
        @JsonProperty(value="script")
        private String script;

        public BigInteger getSequence() {
            return this.sequence;
        }

        public String getWitness() {
            return this.witness;
        }

        public Out getPrevOut() {
            return this.prevOut;
        }

        public String getScript() {
            return this.script;
        }

        @JsonProperty(value="sequence")
        public In setSequence(BigInteger sequence) {
            this.sequence = sequence;
            return this;
        }

        @JsonProperty(value="witness")
        public In setWitness(String witness) {
            this.witness = witness;
            return this;
        }

        @JsonProperty(value="prev_out")
        public In setPrevOut(Out prevOut) {
            this.prevOut = prevOut;
            return this;
        }

        @JsonProperty(value="script")
        public In setScript(String script) {
            this.script = script;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof In)) {
                return false;
            }
            In other = (In)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BigInteger this$sequence = this.getSequence();
            BigInteger other$sequence = other.getSequence();
            if (this$sequence == null ? other$sequence != null : !((Object)this$sequence).equals(other$sequence)) {
                return false;
            }
            String this$witness = this.getWitness();
            String other$witness = other.getWitness();
            if (this$witness == null ? other$witness != null : !this$witness.equals(other$witness)) {
                return false;
            }
            Out this$prevOut = this.getPrevOut();
            Out other$prevOut = other.getPrevOut();
            if (this$prevOut == null ? other$prevOut != null : !((Object)this$prevOut).equals(other$prevOut)) {
                return false;
            }
            String this$script = this.getScript();
            String other$script = other.getScript();
            return !(this$script == null ? other$script != null : !this$script.equals(other$script));
        }

        protected boolean canEqual(Object other) {
            return other instanceof In;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigInteger $sequence = this.getSequence();
            result = result * 59 + ($sequence == null ? 43 : ((Object)$sequence).hashCode());
            String $witness = this.getWitness();
            result = result * 59 + ($witness == null ? 43 : $witness.hashCode());
            Out $prevOut = this.getPrevOut();
            result = result * 59 + ($prevOut == null ? 43 : ((Object)$prevOut).hashCode());
            String $script = this.getScript();
            result = result * 59 + ($script == null ? 43 : $script.hashCode());
            return result;
        }

        public String toString() {
            return "RawTransaction.In(sequence=" + this.getSequence() + ", witness=" + this.getWitness() + ", prevOut=" + this.getPrevOut() + ", script=" + this.getScript() + ")";
        }
    }
}

