/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.virtual.currency.bitcoin.model.cypher;

import cn.hutool.http.HttpRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.math.BigInteger;
import live.lingting.virtual.currency.bitcoin.endpoints.BitcoinCypherEndpoints;
import live.lingting.virtual.currency.core.util.JacksonUtils;

public class Balance {
    private String error;
    @JsonProperty(value="address")
    private String address;
    @JsonProperty(value="total_received")
    private BigInteger totalReceived;
    @JsonProperty(value="total_sent")
    private BigInteger totalSent;
    @JsonProperty(value="balance")
    private BigInteger balance;
    @JsonProperty(value="unconfirmed_balance")
    private BigInteger unconfirmedBalance;
    @JsonProperty(value="final_balance")
    private BigInteger finalBalance;
    @JsonProperty(value="n_tx")
    private BigInteger nTx;
    @JsonProperty(value="unconfirmed_n_tx")
    private BigInteger unconfirmedNumberTx;
    @JsonProperty(value="final_n_tx")
    private BigInteger finalNumberTx;

    public static Balance of(BitcoinCypherEndpoints endpoints, String address) throws JsonProcessingException {
        HttpRequest request = HttpRequest.get((String)endpoints.getHttpUrl("addrs/" + address + "/balance"));
        String response = request.execute().body();
        return (Balance)JacksonUtils.toObj((String)response, Balance.class);
    }

    public String getError() {
        return this.error;
    }

    public String getAddress() {
        return this.address;
    }

    public BigInteger getTotalReceived() {
        return this.totalReceived;
    }

    public BigInteger getTotalSent() {
        return this.totalSent;
    }

    public BigInteger getBalance() {
        return this.balance;
    }

    public BigInteger getUnconfirmedBalance() {
        return this.unconfirmedBalance;
    }

    public BigInteger getFinalBalance() {
        return this.finalBalance;
    }

    public BigInteger getNTx() {
        return this.nTx;
    }

    public BigInteger getUnconfirmedNumberTx() {
        return this.unconfirmedNumberTx;
    }

    public BigInteger getFinalNumberTx() {
        return this.finalNumberTx;
    }

    public Balance setError(String error) {
        this.error = error;
        return this;
    }

    @JsonProperty(value="address")
    public Balance setAddress(String address) {
        this.address = address;
        return this;
    }

    @JsonProperty(value="total_received")
    public Balance setTotalReceived(BigInteger totalReceived) {
        this.totalReceived = totalReceived;
        return this;
    }

    @JsonProperty(value="total_sent")
    public Balance setTotalSent(BigInteger totalSent) {
        this.totalSent = totalSent;
        return this;
    }

    @JsonProperty(value="balance")
    public Balance setBalance(BigInteger balance) {
        this.balance = balance;
        return this;
    }

    @JsonProperty(value="unconfirmed_balance")
    public Balance setUnconfirmedBalance(BigInteger unconfirmedBalance) {
        this.unconfirmedBalance = unconfirmedBalance;
        return this;
    }

    @JsonProperty(value="final_balance")
    public Balance setFinalBalance(BigInteger finalBalance) {
        this.finalBalance = finalBalance;
        return this;
    }

    @JsonProperty(value="n_tx")
    public Balance setNTx(BigInteger nTx) {
        this.nTx = nTx;
        return this;
    }

    @JsonProperty(value="unconfirmed_n_tx")
    public Balance setUnconfirmedNumberTx(BigInteger unconfirmedNumberTx) {
        this.unconfirmedNumberTx = unconfirmedNumberTx;
        return this;
    }

    @JsonProperty(value="final_n_tx")
    public Balance setFinalNumberTx(BigInteger finalNumberTx) {
        this.finalNumberTx = finalNumberTx;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Balance)) {
            return false;
        }
        Balance other = (Balance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        BigInteger this$totalReceived = this.getTotalReceived();
        BigInteger other$totalReceived = other.getTotalReceived();
        if (this$totalReceived == null ? other$totalReceived != null : !((Object)this$totalReceived).equals(other$totalReceived)) {
            return false;
        }
        BigInteger this$totalSent = this.getTotalSent();
        BigInteger other$totalSent = other.getTotalSent();
        if (this$totalSent == null ? other$totalSent != null : !((Object)this$totalSent).equals(other$totalSent)) {
            return false;
        }
        BigInteger this$balance = this.getBalance();
        BigInteger other$balance = other.getBalance();
        if (this$balance == null ? other$balance != null : !((Object)this$balance).equals(other$balance)) {
            return false;
        }
        BigInteger this$unconfirmedBalance = this.getUnconfirmedBalance();
        BigInteger other$unconfirmedBalance = other.getUnconfirmedBalance();
        if (this$unconfirmedBalance == null ? other$unconfirmedBalance != null : !((Object)this$unconfirmedBalance).equals(other$unconfirmedBalance)) {
            return false;
        }
        BigInteger this$finalBalance = this.getFinalBalance();
        BigInteger other$finalBalance = other.getFinalBalance();
        if (this$finalBalance == null ? other$finalBalance != null : !((Object)this$finalBalance).equals(other$finalBalance)) {
            return false;
        }
        BigInteger this$nTx = this.getNTx();
        BigInteger other$nTx = other.getNTx();
        if (this$nTx == null ? other$nTx != null : !((Object)this$nTx).equals(other$nTx)) {
            return false;
        }
        BigInteger this$unconfirmedNumberTx = this.getUnconfirmedNumberTx();
        BigInteger other$unconfirmedNumberTx = other.getUnconfirmedNumberTx();
        if (this$unconfirmedNumberTx == null ? other$unconfirmedNumberTx != null : !((Object)this$unconfirmedNumberTx).equals(other$unconfirmedNumberTx)) {
            return false;
        }
        BigInteger this$finalNumberTx = this.getFinalNumberTx();
        BigInteger other$finalNumberTx = other.getFinalNumberTx();
        return !(this$finalNumberTx == null ? other$finalNumberTx != null : !((Object)this$finalNumberTx).equals(other$finalNumberTx));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Balance;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        BigInteger $totalReceived = this.getTotalReceived();
        result = result * 59 + ($totalReceived == null ? 43 : ((Object)$totalReceived).hashCode());
        BigInteger $totalSent = this.getTotalSent();
        result = result * 59 + ($totalSent == null ? 43 : ((Object)$totalSent).hashCode());
        BigInteger $balance = this.getBalance();
        result = result * 59 + ($balance == null ? 43 : ((Object)$balance).hashCode());
        BigInteger $unconfirmedBalance = this.getUnconfirmedBalance();
        result = result * 59 + ($unconfirmedBalance == null ? 43 : ((Object)$unconfirmedBalance).hashCode());
        BigInteger $finalBalance = this.getFinalBalance();
        result = result * 59 + ($finalBalance == null ? 43 : ((Object)$finalBalance).hashCode());
        BigInteger $nTx = this.getNTx();
        result = result * 59 + ($nTx == null ? 43 : ((Object)$nTx).hashCode());
        BigInteger $unconfirmedNumberTx = this.getUnconfirmedNumberTx();
        result = result * 59 + ($unconfirmedNumberTx == null ? 43 : ((Object)$unconfirmedNumberTx).hashCode());
        BigInteger $finalNumberTx = this.getFinalNumberTx();
        result = result * 59 + ($finalNumberTx == null ? 43 : ((Object)$finalNumberTx).hashCode());
        return result;
    }

    public String toString() {
        return "Balance(error=" + this.getError() + ", address=" + this.getAddress() + ", totalReceived=" + this.getTotalReceived() + ", totalSent=" + this.getTotalSent() + ", balance=" + this.getBalance() + ", unconfirmedBalance=" + this.getUnconfirmedBalance() + ", finalBalance=" + this.getFinalBalance() + ", nTx=" + this.getNTx() + ", unconfirmedNumberTx=" + this.getUnconfirmedNumberTx() + ", finalNumberTx=" + this.getFinalNumberTx() + ")";
    }
}

