/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.virtual.currency.bitcoin.model.sochain;

import cn.hutool.core.collection.CollectionUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import live.lingting.virtual.currency.bitcoin.contract.OmniContract;
import live.lingting.virtual.currency.bitcoin.model.Unspent;
import live.lingting.virtual.currency.bitcoin.model.UnspentRes;

public class SochainUnspentRes
extends UnspentRes {
    public static final String FAIL = "fail";
    private String status;
    private ResData data;

    @Override
    public List<Unspent> toUnspentList() {
        if (this.data == null || CollectionUtil.isEmpty((Collection)this.data.txs)) {
            return Collections.emptyList();
        }
        ArrayList<Unspent> list = new ArrayList<Unspent>(this.data.txs.size());
        for (ResData.Txs tx : this.data.txs) {
            list.add(new Unspent().setValue(tx.value.multiply(BigDecimal.TEN.pow(OmniContract.BTC.getDecimals())).toBigInteger()).setScript(tx.getScriptHex()).setHash(tx.txid).setOut(tx.outputNo).setConfirmations(tx.confirmations));
        }
        return list;
    }

    public String getStatus() {
        return this.status;
    }

    public ResData getData() {
        return this.data;
    }

    public SochainUnspentRes setStatus(String status) {
        this.status = status;
        return this;
    }

    public SochainUnspentRes setData(ResData data) {
        this.data = data;
        return this;
    }

    public static class ResData {
        @JsonProperty(value="network")
        private String network;
        @JsonProperty(value="address")
        private String address;
        @JsonProperty(value="txs")
        private List<Txs> txs;

        public String getNetwork() {
            return this.network;
        }

        public String getAddress() {
            return this.address;
        }

        public List<Txs> getTxs() {
            return this.txs;
        }

        @JsonProperty(value="network")
        public ResData setNetwork(String network) {
            this.network = network;
            return this;
        }

        @JsonProperty(value="address")
        public ResData setAddress(String address) {
            this.address = address;
            return this;
        }

        @JsonProperty(value="txs")
        public ResData setTxs(List<Txs> txs) {
            this.txs = txs;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResData)) {
                return false;
            }
            ResData other = (ResData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$network = this.getNetwork();
            String other$network = other.getNetwork();
            if (this$network == null ? other$network != null : !this$network.equals(other$network)) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                return false;
            }
            List<Txs> this$txs = this.getTxs();
            List<Txs> other$txs = other.getTxs();
            return !(this$txs == null ? other$txs != null : !((Object)this$txs).equals(other$txs));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ResData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $network = this.getNetwork();
            result = result * 59 + ($network == null ? 43 : $network.hashCode());
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            List<Txs> $txs = this.getTxs();
            result = result * 59 + ($txs == null ? 43 : ((Object)$txs).hashCode());
            return result;
        }

        public String toString() {
            return "SochainUnspentRes.ResData(network=" + this.getNetwork() + ", address=" + this.getAddress() + ", txs=" + this.getTxs() + ")";
        }

        public static class Txs {
            @JsonProperty(value="txid")
            private String txid;
            @JsonProperty(value="output_no")
            private Long outputNo;
            @JsonProperty(value="script_asm")
            private String scriptAsm;
            @JsonProperty(value="script_hex")
            private String scriptHex;
            @JsonProperty(value="value")
            private BigDecimal value;
            @JsonProperty(value="confirmations")
            private BigInteger confirmations;
            @JsonProperty(value="time")
            private Long time;

            public String getTxid() {
                return this.txid;
            }

            public Long getOutputNo() {
                return this.outputNo;
            }

            public String getScriptAsm() {
                return this.scriptAsm;
            }

            public String getScriptHex() {
                return this.scriptHex;
            }

            public BigDecimal getValue() {
                return this.value;
            }

            public BigInteger getConfirmations() {
                return this.confirmations;
            }

            public Long getTime() {
                return this.time;
            }

            @JsonProperty(value="txid")
            public Txs setTxid(String txid) {
                this.txid = txid;
                return this;
            }

            @JsonProperty(value="output_no")
            public Txs setOutputNo(Long outputNo) {
                this.outputNo = outputNo;
                return this;
            }

            @JsonProperty(value="script_asm")
            public Txs setScriptAsm(String scriptAsm) {
                this.scriptAsm = scriptAsm;
                return this;
            }

            @JsonProperty(value="script_hex")
            public Txs setScriptHex(String scriptHex) {
                this.scriptHex = scriptHex;
                return this;
            }

            @JsonProperty(value="value")
            public Txs setValue(BigDecimal value) {
                this.value = value;
                return this;
            }

            @JsonProperty(value="confirmations")
            public Txs setConfirmations(BigInteger confirmations) {
                this.confirmations = confirmations;
                return this;
            }

            @JsonProperty(value="time")
            public Txs setTime(Long time) {
                this.time = time;
                return this;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Txs)) {
                    return false;
                }
                Txs other = (Txs)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$txid = this.getTxid();
                String other$txid = other.getTxid();
                if (this$txid == null ? other$txid != null : !this$txid.equals(other$txid)) {
                    return false;
                }
                Long this$outputNo = this.getOutputNo();
                Long other$outputNo = other.getOutputNo();
                if (this$outputNo == null ? other$outputNo != null : !((Object)this$outputNo).equals(other$outputNo)) {
                    return false;
                }
                String this$scriptAsm = this.getScriptAsm();
                String other$scriptAsm = other.getScriptAsm();
                if (this$scriptAsm == null ? other$scriptAsm != null : !this$scriptAsm.equals(other$scriptAsm)) {
                    return false;
                }
                String this$scriptHex = this.getScriptHex();
                String other$scriptHex = other.getScriptHex();
                if (this$scriptHex == null ? other$scriptHex != null : !this$scriptHex.equals(other$scriptHex)) {
                    return false;
                }
                BigDecimal this$value = this.getValue();
                BigDecimal other$value = other.getValue();
                if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
                    return false;
                }
                BigInteger this$confirmations = this.getConfirmations();
                BigInteger other$confirmations = other.getConfirmations();
                if (this$confirmations == null ? other$confirmations != null : !((Object)this$confirmations).equals(other$confirmations)) {
                    return false;
                }
                Long this$time = this.getTime();
                Long other$time = other.getTime();
                return !(this$time == null ? other$time != null : !((Object)this$time).equals(other$time));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Txs;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $txid = this.getTxid();
                result = result * 59 + ($txid == null ? 43 : $txid.hashCode());
                Long $outputNo = this.getOutputNo();
                result = result * 59 + ($outputNo == null ? 43 : ((Object)$outputNo).hashCode());
                String $scriptAsm = this.getScriptAsm();
                result = result * 59 + ($scriptAsm == null ? 43 : $scriptAsm.hashCode());
                String $scriptHex = this.getScriptHex();
                result = result * 59 + ($scriptHex == null ? 43 : $scriptHex.hashCode());
                BigDecimal $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
                BigInteger $confirmations = this.getConfirmations();
                result = result * 59 + ($confirmations == null ? 43 : ((Object)$confirmations).hashCode());
                Long $time = this.getTime();
                result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
                return result;
            }

            public String toString() {
                return "SochainUnspentRes.ResData.Txs(txid=" + this.getTxid() + ", outputNo=" + this.getOutputNo() + ", scriptAsm=" + this.getScriptAsm() + ", scriptHex=" + this.getScriptHex() + ", value=" + this.getValue() + ", confirmations=" + this.getConfirmations() + ", time=" + this.getTime() + ")";
            }
        }
    }
}

