/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.virtual.currency.bitcoin.properties;

import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import live.lingting.virtual.currency.bitcoin.endpoints.BitcoinEndpoints;
import live.lingting.virtual.currency.bitcoin.model.Unspent;
import live.lingting.virtual.currency.bitcoin.model.UnspentRes;
import live.lingting.virtual.currency.bitcoin.model.omni.PushTx;
import live.lingting.virtual.currency.bitcoin.util.BitcoinUtils;
import live.lingting.virtual.currency.core.Endpoints;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.params.MainNetParams;
import org.bitcoinj.params.TestNet3Params;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitcoinProperties {
    private static final Logger log = LoggerFactory.getLogger(BitcoinProperties.class);
    public Supplier<Coin> feeByByte = BitcoinUtils::getSlowFeeByByte;
    public BiFunction<String, Endpoints, PushTx> broadcastTransaction = (raw, endpoints) -> {
        try {
            return PushTx.of(endpoints, raw);
        }
        catch (Exception e) {
            log.error("\u5e7f\u64ad\u4ea4\u6613\u5f02\u5e38!", (Throwable)e);
            return new PushTx(e);
        }
    };
    private BitcoinEndpoints endpoints;
    private NetworkParameters np;
    private Supplier<Boolean> lock = () -> true;
    private Supplier<Boolean> unlock = () -> true;
    private Integer confirmationsMin = 6;
    public BiFunction<String, BitcoinEndpoints, List<Unspent>> unspent = (address, endpoints) -> {
        try {
            return UnspentRes.of(endpoints, this.getConfirmationsMin(), address).toUnspentList();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u672a\u82b1\u8d39\u8f93\u51fa\u5f02\u5e38!", (Throwable)e);
            return Collections.emptyList();
        }
    };

    public NetworkParameters getNp() {
        return this.endpoints == BitcoinEndpoints.MAINNET ? MainNetParams.get() : TestNet3Params.get();
    }

    public Supplier<Coin> getFeeByByte() {
        return this.feeByByte;
    }

    public BiFunction<String, Endpoints, PushTx> getBroadcastTransaction() {
        return this.broadcastTransaction;
    }

    public BitcoinEndpoints getEndpoints() {
        return this.endpoints;
    }

    public Supplier<Boolean> getLock() {
        return this.lock;
    }

    public Supplier<Boolean> getUnlock() {
        return this.unlock;
    }

    public Integer getConfirmationsMin() {
        return this.confirmationsMin;
    }

    public BiFunction<String, BitcoinEndpoints, List<Unspent>> getUnspent() {
        return this.unspent;
    }

    public BitcoinProperties setFeeByByte(Supplier<Coin> feeByByte) {
        this.feeByByte = feeByByte;
        return this;
    }

    public BitcoinProperties setBroadcastTransaction(BiFunction<String, Endpoints, PushTx> broadcastTransaction) {
        this.broadcastTransaction = broadcastTransaction;
        return this;
    }

    public BitcoinProperties setEndpoints(BitcoinEndpoints endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public BitcoinProperties setLock(Supplier<Boolean> lock) {
        this.lock = lock;
        return this;
    }

    public BitcoinProperties setUnlock(Supplier<Boolean> unlock) {
        this.unlock = unlock;
        return this;
    }

    public BitcoinProperties setConfirmationsMin(Integer confirmationsMin) {
        this.confirmationsMin = confirmationsMin;
        return this;
    }

    public BitcoinProperties setUnspent(BiFunction<String, BitcoinEndpoints, List<Unspent>> unspent) {
        this.unspent = unspent;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BitcoinProperties)) {
            return false;
        }
        BitcoinProperties other = (BitcoinProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Supplier<Coin> this$feeByByte = this.getFeeByByte();
        Supplier<Coin> other$feeByByte = other.getFeeByByte();
        if (this$feeByByte == null ? other$feeByByte != null : !this$feeByByte.equals(other$feeByByte)) {
            return false;
        }
        BiFunction<String, Endpoints, PushTx> this$broadcastTransaction = this.getBroadcastTransaction();
        BiFunction<String, Endpoints, PushTx> other$broadcastTransaction = other.getBroadcastTransaction();
        if (this$broadcastTransaction == null ? other$broadcastTransaction != null : !this$broadcastTransaction.equals(other$broadcastTransaction)) {
            return false;
        }
        BitcoinEndpoints this$endpoints = this.getEndpoints();
        BitcoinEndpoints other$endpoints = other.getEndpoints();
        if (this$endpoints == null ? other$endpoints != null : !((Object)((Object)this$endpoints)).equals((Object)other$endpoints)) {
            return false;
        }
        NetworkParameters this$np = this.getNp();
        NetworkParameters other$np = other.getNp();
        if (this$np == null ? other$np != null : !this$np.equals(other$np)) {
            return false;
        }
        Supplier<Boolean> this$lock = this.getLock();
        Supplier<Boolean> other$lock = other.getLock();
        if (this$lock == null ? other$lock != null : !this$lock.equals(other$lock)) {
            return false;
        }
        Supplier<Boolean> this$unlock = this.getUnlock();
        Supplier<Boolean> other$unlock = other.getUnlock();
        if (this$unlock == null ? other$unlock != null : !this$unlock.equals(other$unlock)) {
            return false;
        }
        Integer this$confirmationsMin = this.getConfirmationsMin();
        Integer other$confirmationsMin = other.getConfirmationsMin();
        if (this$confirmationsMin == null ? other$confirmationsMin != null : !((Object)this$confirmationsMin).equals(other$confirmationsMin)) {
            return false;
        }
        BiFunction<String, BitcoinEndpoints, List<Unspent>> this$unspent = this.getUnspent();
        BiFunction<String, BitcoinEndpoints, List<Unspent>> other$unspent = other.getUnspent();
        return !(this$unspent == null ? other$unspent != null : !this$unspent.equals(other$unspent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BitcoinProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Supplier<Coin> $feeByByte = this.getFeeByByte();
        result = result * 59 + ($feeByByte == null ? 43 : $feeByByte.hashCode());
        BiFunction<String, Endpoints, PushTx> $broadcastTransaction = this.getBroadcastTransaction();
        result = result * 59 + ($broadcastTransaction == null ? 43 : $broadcastTransaction.hashCode());
        BitcoinEndpoints $endpoints = this.getEndpoints();
        result = result * 59 + ($endpoints == null ? 43 : ((Object)((Object)$endpoints)).hashCode());
        NetworkParameters $np = this.getNp();
        result = result * 59 + ($np == null ? 43 : $np.hashCode());
        Supplier<Boolean> $lock = this.getLock();
        result = result * 59 + ($lock == null ? 43 : $lock.hashCode());
        Supplier<Boolean> $unlock = this.getUnlock();
        result = result * 59 + ($unlock == null ? 43 : $unlock.hashCode());
        Integer $confirmationsMin = this.getConfirmationsMin();
        result = result * 59 + ($confirmationsMin == null ? 43 : ((Object)$confirmationsMin).hashCode());
        BiFunction<String, BitcoinEndpoints, List<Unspent>> $unspent = this.getUnspent();
        result = result * 59 + ($unspent == null ? 43 : $unspent.hashCode());
        return result;
    }

    public String toString() {
        return "BitcoinProperties(feeByByte=" + this.getFeeByByte() + ", broadcastTransaction=" + this.getBroadcastTransaction() + ", endpoints=" + (Object)((Object)this.getEndpoints()) + ", np=" + this.getNp() + ", lock=" + this.getLock() + ", unlock=" + this.getUnlock() + ", confirmationsMin=" + this.getConfirmationsMin() + ", unspent=" + this.getUnspent() + ")";
    }
}

