/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.virtual.currency.bitcoin.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import live.lingting.virtual.currency.core.model.Account;
import live.lingting.virtual.currency.core.model.TransferParams;
import live.lingting.virtual.currency.core.util.JacksonUtils;
import org.bitcoinj.core.Base58;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.DumpedPrivateKey;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.LegacyAddress;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.SegwitAddress;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Utils;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitcoinUtils {
    private static final Logger log = LoggerFactory.getLogger(BitcoinUtils.class);
    public static final String PROPERTY_PREFIX = "6a146f6d6e69";

    public static Account createLegacyAddress(NetworkParameters np) {
        return BitcoinUtils.createLegacyAddress(np, new ECKey(new SecureRandom()));
    }

    public static Account createLegacyAddress(NetworkParameters np, ECKey ecKey) {
        return new Account().setAddress(LegacyAddress.fromKey((NetworkParameters)np, (ECKey)ecKey).toString()).setPrivateKey(ecKey.getPrivateKeyAsHex()).setPublicKey(ecKey.getPublicKeyAsHex());
    }

    public static Account createSegwitAddress(NetworkParameters np) {
        return BitcoinUtils.createSegwitAddress(np, new ECKey(new SecureRandom()));
    }

    public static Account createSegwitAddress(NetworkParameters np, ECKey ecKey) {
        return new Account().setAddress(SegwitAddress.fromKey((NetworkParameters)np, (ECKey)ecKey).toString()).setPrivateKey(ecKey.getPrivateKeyAsHex()).setPublicKey(ecKey.getPublicKeyAsHex());
    }

    public static Account createMultiAddress(NetworkParameters parameters, int min, int number) {
        ArrayList<ECKey> keys = new ArrayList<ECKey>();
        for (int i = 0; i < number; ++i) {
            keys.add(new ECKey(new SecureRandom()));
        }
        return BitcoinUtils.createMultiAddress(parameters, min, keys);
    }

    public static Account createMultiAddress(NetworkParameters np, int min, List<ECKey> keys) {
        StringBuilder script = new StringBuilder(Hex.toHexString((byte[])new byte[]{(byte)(80 + min)}));
        ArrayList<String> publicKeys = new ArrayList<String>(keys.size());
        ArrayList<String> privateKeys = new ArrayList<String>(keys.size());
        for (ECKey key : keys) {
            String publicKeyAsHex = key.getPublicKeyAsHex();
            publicKeys.add(publicKeyAsHex);
            privateKeys.add(key.getPrivateKeyAsHex());
            script.append("21").append(publicKeyAsHex);
        }
        script.append(Hex.toHexString((byte[])new byte[]{(byte)(80 + keys.size())})).append("ae");
        return BitcoinUtils.createMultiAddress(np, script.toString(), publicKeys, privateKeys);
    }

    public static Account createMultiAddress(NetworkParameters np, String script, List<String> publicKeys, List<String> privateKeys) {
        String address = Base58.encodeChecked((int)np.getP2SHHeader(), (byte[])Utils.sha256hash160((byte[])Hex.decode((String)script)));
        return new Account().setAddress(address).setMulti(Boolean.valueOf(true)).setPrivateKeyArray(privateKeys).setPublicKeyArray(publicKeys);
    }

    public static Account createMultiSegwitAddress(NetworkParameters np) {
        return BitcoinUtils.createMultiSegwitAddress(np, new ECKey(new SecureRandom()));
    }

    public static Account createMultiSegwitAddress(NetworkParameters np, ECKey key) {
        String publicKeyHash = "0014" + Hex.toHexString((byte[])key.getPubKeyHash());
        byte[] hash160 = Utils.sha256hash160((byte[])Hex.decode((String)publicKeyHash));
        byte[] versionByte = ArrayUtil.addAll((byte[][])new byte[][]{{(byte)np.getP2SHHeader()}, hash160});
        byte[] twice = Sha256Hash.hashTwice((byte[])versionByte);
        byte[] valid = new byte[]{twice[0], twice[1], twice[2], twice[3]};
        String address = Base58.encode((byte[])ArrayUtil.addAll((byte[][])new byte[][]{versionByte, valid}));
        return new Account(address, key.getPublicKeyAsHex(), key.getPrivateKeyAsHex());
    }

    public static Account getAccountOfKey(String address, String privateKey) {
        return BitcoinUtils.getAccountOfKey(address, null, privateKey);
    }

    public static Account getAccountOfKey(String address, String publicKey, String privateKey) {
        Assert.isFalse((boolean)StrUtil.isBlank((CharSequence)address));
        Assert.isFalse((boolean)StrUtil.isBlank((CharSequence)privateKey));
        Account account = new Account(address, publicKey, privateKey);
        if (StrUtil.isBlank((CharSequence)publicKey)) {
            ECKey ecKey = ECKey.fromPrivate((byte[])Hex.decode((String)privateKey));
            publicKey = ecKey.getPublicKeyAsHex();
        }
        account.setPublicKey(publicKey);
        return account;
    }

    public static Account getMultiAccountOfKey(String address, int multiNum, List<String> publicKeyArray, List<String> privateKeyArray) {
        Assert.isFalse((multiNum < 1 ? 1 : 0) != 0);
        Assert.isFalse((boolean)StrUtil.isBlank((CharSequence)address));
        Assert.isFalse((boolean)CollectionUtil.isEmpty(publicKeyArray));
        Assert.isFalse((boolean)CollectionUtil.isEmpty(privateKeyArray));
        Assert.isFalse((publicKeyArray.size() != privateKeyArray.size() ? 1 : 0) != 0);
        return new Account(address, multiNum, publicKeyArray, privateKeyArray);
    }

    public static Coin btcToCoin(BigDecimal btc) {
        return BitcoinUtils.btcToCoin(btc.multiply(BigDecimal.TEN.pow(8)).toBigInteger());
    }

    public static Coin btcToCoin(BigInteger btc) {
        return Coin.valueOf((long)btc.longValue());
    }

    public static BigInteger coinToBtcBalance(Coin coin) {
        return new BigInteger(coin.toString());
    }

    public static BigDecimal coinToBtc(Coin coin) {
        return new BigDecimal(coin.toPlainString());
    }

    public static Coin getSumFee(long inNumber, long outNumber, Coin fee) {
        return fee.multiply(inNumber * 148L + outNumber * 34L + 10L);
    }

    public static Coin getSumFee(long inNumber, long outNumber, TransferParams params) {
        if (params.getSumFee() == null) {
            return BitcoinUtils.getSumFee(inNumber, outNumber, params.getFee());
        }
        return params.getSumFee();
    }

    public static String hexToWif(NetworkParameters np, byte[] bytes, boolean compressed) {
        if (compressed) {
            bytes = ArrayUtil.addAll((byte[][])new byte[][]{bytes, {1}});
        }
        return Base58.encodeChecked((int)np.getDumpedPrivateKeyHeader(), (byte[])bytes);
    }

    public static String wifToHex(NetworkParameters np, String wif) {
        return BitcoinUtils.wifToEcKey(np, wif).getPrivateKeyAsHex();
    }

    public static ECKey wifToEcKey(NetworkParameters np, String wif) {
        return DumpedPrivateKey.fromBase58((NetworkParameters)np, (String)wif).getKey();
    }

    public static Coin getSlowFeeByByte() {
        return BitcoinUtils.getFeeByByte("hourFee");
    }

    public static Coin getMediumFeeByByte() {
        return BitcoinUtils.getFeeByByte("halfHourFee");
    }

    public static Coin getFastFeeByByte() {
        return BitcoinUtils.getFeeByByte("fastestFee");
    }

    private static Coin getFeeByByte(String key) {
        HttpRequest request = HttpRequest.get((String)"https://bitcoinfees.earn.com/api/v1/fees/recommended");
        try {
            return Coin.valueOf((long)Convert.toLong(((Map)JacksonUtils.toObj((String)request.execute().body(), Map.class)).get(key)));
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8d39\u7528\u5931\u8d25!", (Throwable)e);
            return Coin.valueOf((long)100L);
        }
    }

    private BitcoinUtils() {
    }
}

