/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.virtual.currency.core;

import cn.hutool.core.util.ArrayUtil;
import com.google.common.base.Splitter;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.List;
import live.lingting.virtual.currency.core.bip.Bip32;
import live.lingting.virtual.currency.core.exception.MnemonicNumberException;
import org.bitcoinj.crypto.DeterministicKey;
import org.bitcoinj.crypto.HDKeyDerivation;
import org.bitcoinj.crypto.HDUtils;
import org.bitcoinj.wallet.DeterministicSeed;

public class Mnemonic {
    public static final int QUANTITY_MIN = 11;
    public static final int QUANTITY_3 = 3;
    public static final int QUANTITY_MAX = 24;
    public static final int QUANTITY_DEFAULT = 12;
    public static final String PASSWORD_DEFAULT = "";
    public static final String FLAG = " ";
    private final DeterministicSeed seed;
    private final Bip32 bip;

    private Mnemonic(DeterministicSeed seed) {
        this.seed = seed;
        this.bip = Bip32.create(this.generateMasterKey());
    }

    public static Mnemonic create() {
        return Mnemonic.create(12, PASSWORD_DEFAULT);
    }

    public static Mnemonic create(int quantity, String password) {
        if (quantity <= 11 || quantity % 3 != 0 || quantity > 24) {
            throw new MnemonicNumberException();
        }
        return new Mnemonic(new DeterministicSeed(new SecureRandom(), quantity / 3 * 32, password));
    }

    public static Mnemonic of(String mnemonics, byte[] seed, String password, long creationTimeSeconds) {
        return Mnemonic.of(Splitter.on((String)FLAG).splitToList((CharSequence)mnemonics), seed, password, creationTimeSeconds);
    }

    public static Mnemonic of(List<String> mnemonics, byte[] seed, String password, long creationTimeSeconds) {
        return Mnemonic.of(new DeterministicSeed(mnemonics, seed, password, creationTimeSeconds));
    }

    public static Mnemonic of(DeterministicSeed seed) {
        return new Mnemonic(seed);
    }

    public List<String> getMnemonics() {
        return this.seed.getMnemonicCode();
    }

    public String getMnemonic() {
        return String.join((CharSequence)FLAG, this.getMnemonics());
    }

    public byte[] getSeedBytes() {
        return this.seed.getSeedBytes();
    }

    public DeterministicKey generateMasterKey() {
        byte[] hmacSha512 = HDUtils.hmacSha512((byte[])"Bitcoin seed".getBytes(StandardCharsets.UTF_8), (byte[])this.getSeedBytes());
        byte[][] split = ArrayUtil.split((byte[])hmacSha512, (int)32);
        byte[] il = split[0];
        byte[] ir = split[1];
        return HDKeyDerivation.createMasterPrivKeyFromBytes((byte[])il, (byte[])ir);
    }

    public DeterministicKey getMasterKey() {
        return this.bip.getKey();
    }

    public DeterministicKey getKeyByPathFromRoot(String path) {
        return this.bip.getKeyByPath(path);
    }

    public DeterministicKey getKeyByPathAndIndexFromRoot(String path, int index) {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        return this.getKeyByPathFromRoot(path + index);
    }

    public DeterministicSeed getSeed() {
        return this.seed;
    }

    public Bip32 getBip() {
        return this.bip;
    }
}

