/*
 * Decompiled with CFR 0.152.
 */
package live.lingting.virtual.currency.core.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonUtils {
    private static final Logger log = LoggerFactory.getLogger(JacksonUtils.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static String toJson(Object o) throws JsonProcessingException {
        return MAPPER.writeValueAsString(o);
    }

    public static <T> T toObj(String json, Class<T> t) throws JsonProcessingException {
        return (T)MAPPER.readValue(json, t);
    }

    public static <T> T toObj(String json, Type type) throws JsonProcessingException {
        return (T)MAPPER.readValue(json, MAPPER.constructType(type));
    }

    public static <T> T toObj(String json, TypeReference<T> ref) throws JsonProcessingException {
        return (T)MAPPER.readValue(json, ref);
    }

    public static <T> T toObj(InputStream inputStream, Class<T> t) throws IOException {
        return (T)MAPPER.readValue(inputStream, t);
    }

    public static <T> T toObj(InputStream inputStream, Type type) throws IOException {
        return (T)MAPPER.readValue(inputStream, MAPPER.constructType(type));
    }

    public static <T> T toObj(InputStream inputStream, TypeReference<T> ref) throws IOException {
        return (T)MAPPER.readValue(inputStream, ref);
    }

    public static void registerSubtype(Class<?> clz, String type) {
        MAPPER.registerSubtypes(new NamedType[]{new NamedType(clz, type)});
    }

    public static ObjectNode createEmptyJsonNode() {
        return new ObjectNode(MAPPER.getNodeFactory());
    }

    public static ArrayNode createEmptyArrayNode() {
        return new ArrayNode(MAPPER.getNodeFactory());
    }

    public static JsonNode transferToJsonNode(Object obj) {
        return MAPPER.valueToTree(obj);
    }

    public static JavaType constructJavaType(Type type) {
        return MAPPER.constructType(type);
    }

    private JacksonUtils() {
    }

    static {
        MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        MAPPER.enable(new JsonParser.Feature[]{JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature()});
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

