/*
 * Decompiled with CFR 0.152.
 */
package org.tron.tronj.crypto;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Security;
import java.security.spec.ECGenParameterSpec;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.bouncycastle.math.ec.custom.sec.SecP256K1Curve;
import org.tron.tronj.crypto.tuweniTypes.Bytes;
import org.tron.tronj.crypto.tuweniTypes.Bytes32;
import org.tron.tronj.crypto.tuweniTypes.MutableBytes;
import org.tron.tronj.crypto.tuweniTypes.UInt256;

public class SECP256K1 {
    public static final String ALGORITHM = "ECDSA";
    public static final String CURVE_NAME = "secp256k1";
    public static final String PROVIDER = "BC";
    public static final ECDomainParameters CURVE;
    public static final BigInteger HALF_CURVE_ORDER;
    private static final KeyPairGenerator KEY_PAIR_GENERATOR;
    private static final BigInteger CURVE_ORDER;

    public static Signature sign(Bytes32 dataHash, KeyPair keyPair) {
        return SECP256K1.signDefault(dataHash, keyPair);
    }

    public static boolean verify(Bytes data, Signature signature, PublicKey pub) {
        return SECP256K1.verifyDefault(data, signature, pub);
    }

    private static ECPoint decompressKey(BigInteger xBN, boolean yBit) {
        X9IntegerConverter x9 = new X9IntegerConverter();
        byte[] compEnc = x9.integerToBytes(xBN, 1 + x9.getByteLength(CURVE.getCurve()));
        compEnc[0] = (byte)(yBit ? 3 : 2);
        return CURVE.getCurve().decodePoint(compEnc);
    }

    private static BigInteger recoverFromSignature(int recId, BigInteger r, BigInteger s, Bytes32 dataHash) {
        BigInteger prime;
        assert (recId >= 0);
        assert (r.signum() >= 0);
        assert (s.signum() >= 0);
        assert (dataHash != null);
        BigInteger n = CURVE.getN();
        BigInteger i = BigInteger.valueOf((long)recId / 2L);
        BigInteger x = r.add(i.multiply(n));
        if (x.compareTo(prime = SecP256K1Curve.q) >= 0) {
            return null;
        }
        ECPoint R = SECP256K1.decompressKey(x, (recId & 1) == 1);
        if (!R.multiply(n).isInfinity()) {
            return null;
        }
        BigInteger e = dataHash.toUnsignedBigInteger();
        BigInteger eInv = BigInteger.ZERO.subtract(e).mod(n);
        BigInteger rInv = r.modInverse(n);
        BigInteger srInv = rInv.multiply(s).mod(n);
        BigInteger eInvrInv = rInv.multiply(eInv).mod(n);
        ECPoint q = ECAlgorithms.sumOfTwoMultiplies((ECPoint)CURVE.getG(), (BigInteger)eInvrInv, (ECPoint)R, (BigInteger)srInv);
        if (q.isInfinity()) {
            return null;
        }
        byte[] qBytes = q.getEncoded(false);
        return new BigInteger(1, Arrays.copyOfRange(qBytes, 1, qBytes.length));
    }

    private static Signature signDefault(Bytes32 dataHash, KeyPair keyPair) {
        ECDSASigner signer = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
        ECPrivateKeyParameters privKey = new ECPrivateKeyParameters(keyPair.getPrivateKey().getEncodedBytes().toUnsignedBigInteger(), CURVE);
        signer.init(true, (CipherParameters)privKey);
        BigInteger[] components = signer.generateSignature(dataHash.toArrayUnsafe());
        return SECP256K1.normaliseSignature(components[0], components[1], keyPair.getPublicKey(), dataHash);
    }

    public static Signature normaliseSignature(BigInteger nativeR, BigInteger nativeS, PublicKey publicKey, Bytes32 dataHash) {
        BigInteger s = nativeS;
        if (s.compareTo(HALF_CURVE_ORDER) > 0) {
            s = CURVE.getN().subtract(s);
        }
        int recId = -1;
        BigInteger publicKeyBI = publicKey.getEncodedBytes().toUnsignedBigInteger();
        for (int i = 0; i < 4; ++i) {
            BigInteger k = SECP256K1.recoverFromSignature(i, nativeR, s, dataHash);
            if (k == null || !k.equals(publicKeyBI)) continue;
            recId = i;
            break;
        }
        if (recId == -1) {
            throw new RuntimeException("Could not construct a recoverable key. This should never happen.");
        }
        return new Signature(nativeR, s, (byte)recId);
    }

    private static boolean verifyDefault(Bytes data, Signature signature, PublicKey pub) {
        ECDSASigner signer = new ECDSASigner();
        Bytes toDecode = Bytes.wrap(Bytes.of(4), pub.getEncodedBytes());
        ECPublicKeyParameters params = new ECPublicKeyParameters(CURVE.getCurve().decodePoint(toDecode.toArrayUnsafe()), CURVE);
        signer.init(false, (CipherParameters)params);
        try {
            return signer.verifySignature(data.toArrayUnsafe(), signature.r, signature.s);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public static boolean verify(Bytes data, Signature signature, PublicKey pub, UnaryOperator<Bytes> preprocessor) {
        assert (preprocessor != null) : "preprocessor must not be null";
        return SECP256K1.verify((Bytes)preprocessor.apply(data), signature, pub);
    }

    public static Bytes32 calculateECDHKeyAgreement(PrivateKey privKey, PublicKey theirPubKey) {
        assert (privKey != null) : "missing private key";
        assert (theirPubKey != null) : "missing remote public key";
        ECPrivateKeyParameters privKeyP = new ECPrivateKeyParameters(privKey.getD(), CURVE);
        ECPublicKeyParameters pubKeyP = new ECPublicKeyParameters(theirPubKey.asEcPoint(), CURVE);
        ECDHBasicAgreement agreement = new ECDHBasicAgreement();
        agreement.init((CipherParameters)privKeyP);
        BigInteger agreed = agreement.calculateAgreement((CipherParameters)pubKeyP);
        return UInt256.valueOf(agreed).toBytes();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        X9ECParameters params = SECNamedCurves.getByName((String)CURVE_NAME);
        CURVE = new ECDomainParameters(params.getCurve(), params.getG(), params.getN(), params.getH());
        CURVE_ORDER = CURVE.getN();
        HALF_CURVE_ORDER = CURVE_ORDER.shiftRight(1);
        try {
            KEY_PAIR_GENERATOR = KeyPairGenerator.getInstance(ALGORITHM, PROVIDER);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ECGenParameterSpec ecGenParameterSpec = new ECGenParameterSpec(CURVE_NAME);
        try {
            KEY_PAIR_GENERATOR.initialize(ecGenParameterSpec);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Signature {
        public static final int BYTES_REQUIRED = 65;
        private final byte recId;
        private final BigInteger r;
        private final BigInteger s;

        Signature(BigInteger r, BigInteger s, byte recId) {
            this.r = r;
            this.s = s;
            this.recId = recId;
        }

        public static Signature create(BigInteger r, BigInteger s, byte recId) {
            assert (r != null);
            assert (s != null);
            Signature.checkInBounds("r", r);
            Signature.checkInBounds("s", s);
            if (recId != 0 && recId != 1) {
                throw new IllegalArgumentException("Invalid 'recId' value, should be 0 or 1 but got " + recId);
            }
            return new Signature(r, s, recId);
        }

        private static void checkInBounds(String name, BigInteger i) {
            if (i.compareTo(BigInteger.ONE) < 0) {
                throw new IllegalArgumentException(String.format("Invalid '%s' value, should be >= 1 but got %s", name, i));
            }
            if (i.compareTo(CURVE_ORDER) >= 0) {
                throw new IllegalArgumentException(String.format("Invalid '%s' value, should be < %s but got %s", CURVE_ORDER, name, i));
            }
        }

        public static Signature decode(Bytes bytes) {
            assert (bytes.size() == 65) : "encoded SECP256K1 signature must be 65 bytes long";
            BigInteger r = bytes.slice(0, 32).toUnsignedBigInteger();
            BigInteger s = bytes.slice(32, 32).toUnsignedBigInteger();
            byte recId = bytes.get(64);
            return Signature.create(r, s, recId);
        }

        public Bytes encodedBytes() {
            MutableBytes bytes = MutableBytes.create(65);
            UInt256.valueOf(this.r).toBytes().copyTo(bytes, 0);
            UInt256.valueOf(this.s).toBytes().copyTo(bytes, 32);
            bytes.set(64, this.recId);
            return bytes;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Signature)) {
                return false;
            }
            Signature that = (Signature)other;
            return this.r.equals(that.r) && this.s.equals(that.s) && this.recId == that.recId;
        }

        public int hashCode() {
            return Objects.hash(this.r, this.s, this.recId);
        }

        public byte getRecId() {
            return this.recId;
        }

        public BigInteger getR() {
            return this.r;
        }

        public BigInteger getS() {
            return this.s;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("SECP256K1.Signature").append("{");
            sb.append("r=").append(this.r).append(", ");
            sb.append("s=").append(this.s).append(", ");
            sb.append("recId=").append(this.recId);
            return sb.append("}").toString();
        }
    }

    public static class KeyPair {
        private final PrivateKey privateKey;
        private final PublicKey publicKey;

        public KeyPair(PrivateKey privateKey, PublicKey publicKey) {
            assert (privateKey != null);
            assert (publicKey != null);
            this.privateKey = privateKey;
            this.publicKey = publicKey;
        }

        public static KeyPair create(PrivateKey privateKey) {
            return new KeyPair(privateKey, PublicKey.create(privateKey));
        }

        public static KeyPair generate() {
            java.security.KeyPair rawKeyPair = KEY_PAIR_GENERATOR.generateKeyPair();
            BCECPrivateKey privateKey = (BCECPrivateKey)rawKeyPair.getPrivate();
            BCECPublicKey publicKey = (BCECPublicKey)rawKeyPair.getPublic();
            BigInteger privateKeyValue = privateKey.getD();
            byte[] publicKeyBytes = publicKey.getQ().getEncoded(false);
            BigInteger publicKeyValue = new BigInteger(1, Arrays.copyOfRange(publicKeyBytes, 1, publicKeyBytes.length));
            return new KeyPair(PrivateKey.create(privateKeyValue), PublicKey.create(publicKeyValue));
        }

        public int hashCode() {
            return Objects.hash(this.privateKey, this.publicKey);
        }

        public boolean equals(Object other) {
            if (!(other instanceof KeyPair)) {
                return false;
            }
            KeyPair that = (KeyPair)other;
            return this.privateKey.equals(that.privateKey) && this.publicKey.equals(that.publicKey);
        }

        public PrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public PublicKey getPublicKey() {
            return this.publicKey;
        }
    }

    public static class PublicKey
    implements java.security.PublicKey {
        private static final int BYTE_LENGTH = 64;
        private final Bytes encoded;

        public static PublicKey create(PrivateKey privateKey) {
            BigInteger privKey = privateKey.getEncodedBytes().toUnsignedBigInteger();
            if (privKey.bitLength() > CURVE.getN().bitLength()) {
                privKey = privKey.mod(CURVE.getN());
            }
            ECPoint point = new FixedPointCombMultiplier().multiply(CURVE.getG(), privKey);
            return PublicKey.create(Bytes.wrap(Arrays.copyOfRange(point.getEncoded(false), 1, 65)));
        }

        private static Bytes toBytes64(byte[] backing) {
            if (backing.length == 64) {
                return Bytes.wrap(backing);
            }
            if (backing.length > 64) {
                return Bytes.wrap(backing, backing.length - 64, 64);
            }
            MutableBytes res = MutableBytes.create(64);
            Bytes.wrap(backing).copyTo(res, 64 - backing.length);
            return res;
        }

        public static PublicKey create(BigInteger key) {
            assert (key != null);
            return PublicKey.create(PublicKey.toBytes64(key.toByteArray()));
        }

        public static PublicKey create(Bytes encoded) {
            return new PublicKey(encoded);
        }

        public static Optional<PublicKey> recoverFromSignature(Bytes32 dataHash, Signature signature) {
            BigInteger publicKeyBI = SECP256K1.recoverFromSignature(signature.getRecId(), signature.getR(), signature.getS(), dataHash);
            return Optional.ofNullable(publicKeyBI).map(PublicKey::create);
        }

        private PublicKey(Bytes encoded) {
            assert (encoded != null);
            assert (encoded.size() == 64);
            this.encoded = encoded;
        }

        public ECPoint asEcPoint() {
            Bytes val = Bytes.concatenate(Bytes.of(4), this.encoded);
            return CURVE.getCurve().decodePoint(val.toArrayUnsafe());
        }

        public boolean equals(Object other) {
            if (!(other instanceof PublicKey)) {
                return false;
            }
            PublicKey that = (PublicKey)other;
            return this.encoded.equals(that.encoded);
        }

        @Override
        public byte[] getEncoded() {
            return this.encoded.toArrayUnsafe();
        }

        public Bytes getEncodedBytes() {
            return this.encoded;
        }

        @Override
        public String getAlgorithm() {
            return SECP256K1.ALGORITHM;
        }

        @Override
        public String getFormat() {
            return null;
        }

        public int hashCode() {
            return this.encoded.hashCode();
        }

        public String toString() {
            return this.encoded.toString();
        }
    }

    public static class PrivateKey
    implements java.security.PrivateKey {
        private final Bytes32 encoded;

        private PrivateKey(Bytes32 encoded) {
            assert (encoded != null);
            this.encoded = encoded;
        }

        public static PrivateKey create(BigInteger key) {
            assert (key != null);
            return PrivateKey.create(UInt256.valueOf(key).toBytes());
        }

        public static PrivateKey create(Bytes32 key) {
            return new PrivateKey(key);
        }

        public static PrivateKey create(String hexKey) {
            assert (hexKey.length() == 64);
            return PrivateKey.create(Bytes32.fromHexString(hexKey));
        }

        public boolean equals(Object other) {
            if (!(other instanceof PrivateKey)) {
                return false;
            }
            PrivateKey that = (PrivateKey)other;
            return this.encoded.equals(that.encoded);
        }

        @Override
        public byte[] getEncoded() {
            return this.encoded.toArrayUnsafe();
        }

        public Bytes32 getEncodedBytes() {
            return this.encoded;
        }

        public BigInteger getD() {
            return this.encoded.toUnsignedBigInteger();
        }

        @Override
        public String getAlgorithm() {
            return SECP256K1.ALGORITHM;
        }

        @Override
        public String getFormat() {
            return null;
        }

        public int hashCode() {
            return this.encoded.hashCode();
        }

        public String toString() {
            return this.encoded.toString();
        }
    }
}

