/*
 * Decompiled with CFR 0.152.
 */
package org.tron.tronj.crypto.tuweniTypes;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.vertx.core.buffer.Buffer;
import java.nio.ByteBuffer;
import org.tron.tronj.crypto.tuweniTypes.Bytes;
import org.tron.tronj.crypto.tuweniTypes.MutableArrayWrappingBytes;
import org.tron.tronj.crypto.tuweniTypes.MutableArrayWrappingBytes32;
import org.tron.tronj.crypto.tuweniTypes.MutableBufferWrappingBytes;
import org.tron.tronj.crypto.tuweniTypes.MutableByteBufWrappingBytes;
import org.tron.tronj.crypto.tuweniTypes.MutableByteBufferWrappingBytes;
import org.tron.tronj.crypto.tuweniTypes.MutableBytes32;

public interface MutableBytes
extends Bytes {
    public static final MutableBytes EMPTY = MutableBytes.wrap(new byte[0]);

    public static MutableBytes create(int size) {
        if (size == 32) {
            return MutableBytes32.create();
        }
        return new MutableByteBufferWrappingBytes(ByteBuffer.allocate(size));
    }

    public static MutableBytes wrap(byte[] value) {
        Preconditions.checkNotNull((Object)value);
        return new MutableArrayWrappingBytes(value);
    }

    public static MutableBytes wrap(byte[] value, int offset, int length) {
        Preconditions.checkNotNull((Object)value);
        if (length == 32) {
            return new MutableArrayWrappingBytes32(value, offset);
        }
        return new MutableArrayWrappingBytes(value, offset, length);
    }

    public static MutableBytes wrapBuffer(Buffer buffer) {
        Preconditions.checkNotNull((Object)buffer);
        if (buffer.length() == 0) {
            return EMPTY;
        }
        return new MutableBufferWrappingBytes(buffer);
    }

    public static MutableBytes wrapBuffer(Buffer buffer, int offset, int size) {
        Preconditions.checkNotNull((Object)buffer);
        if (size == 0) {
            return EMPTY;
        }
        return new MutableBufferWrappingBytes(buffer, offset, size);
    }

    public static MutableBytes wrapByteBuf(ByteBuf byteBuf) {
        Preconditions.checkNotNull((Object)byteBuf);
        if (byteBuf.capacity() == 0) {
            return EMPTY;
        }
        return new MutableByteBufWrappingBytes(byteBuf);
    }

    public static MutableBytes wrapByteBuf(ByteBuf byteBuf, int offset, int size) {
        Preconditions.checkNotNull((Object)byteBuf);
        if (size == 0) {
            return EMPTY;
        }
        return new MutableByteBufWrappingBytes(byteBuf, offset, size);
    }

    public static MutableBytes wrapByteBuffer(ByteBuffer byteBuffer) {
        Preconditions.checkNotNull((Object)byteBuffer);
        if (byteBuffer.limit() == 0) {
            return EMPTY;
        }
        return new MutableByteBufferWrappingBytes(byteBuffer);
    }

    public static MutableBytes wrapByteBuffer(ByteBuffer byteBuffer, int offset, int size) {
        Preconditions.checkNotNull((Object)byteBuffer);
        if (size == 0) {
            return EMPTY;
        }
        return new MutableByteBufferWrappingBytes(byteBuffer, offset, size);
    }

    public static MutableBytes of(byte ... bytes) {
        return MutableBytes.wrap(bytes);
    }

    public static MutableBytes of(int ... bytes) {
        byte[] result = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i];
            Preconditions.checkArgument((b == ((byte)b & 0xFF) ? 1 : 0) != 0, (String)"%sth value %s does not fit a byte", (int)(i + 1), (int)b);
            result[i] = (byte)b;
        }
        return MutableBytes.wrap(result);
    }

    public void set(int var1, byte var2);

    default public void set(int offset, Bytes bytes) {
        for (int i = 0; i < bytes.size(); ++i) {
            this.set(offset + i, bytes.get(i));
        }
    }

    default public void setInt(int i, int value) {
        int size = this.size();
        Preconditions.checkElementIndex((int)i, (int)size);
        if (i > size - 4) {
            throw new IndexOutOfBoundsException(String.format("Value of size %s has not enough bytes to write a 4 bytes int from index %s", size, i));
        }
        this.set(i++, (byte)(value >>> 24));
        this.set(i++, (byte)(value >>> 16 & 0xFF));
        this.set(i++, (byte)(value >>> 8 & 0xFF));
        this.set(i, (byte)(value & 0xFF));
    }

    default public void setLong(int i, long value) {
        int size = this.size();
        Preconditions.checkElementIndex((int)i, (int)size);
        if (i > size - 8) {
            throw new IndexOutOfBoundsException(String.format("Value of size %s has not enough bytes to write a 8 bytes long from index %s", size, i));
        }
        this.set(i++, (byte)(value >>> 56));
        this.set(i++, (byte)(value >>> 48 & 0xFFL));
        this.set(i++, (byte)(value >>> 40 & 0xFFL));
        this.set(i++, (byte)(value >>> 32 & 0xFFL));
        this.set(i++, (byte)(value >>> 24 & 0xFFL));
        this.set(i++, (byte)(value >>> 16 & 0xFFL));
        this.set(i++, (byte)(value >>> 8 & 0xFFL));
        this.set(i, (byte)(value & 0xFFL));
    }

    default public MutableBytes increment() {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (this.get(i) != -1) {
                byte currentValue = this.get(i);
                currentValue = (byte)(currentValue + 1);
                this.set(i, currentValue);
                break;
            }
            this.set(i, (byte)0);
        }
        return this;
    }

    default public MutableBytes decrement() {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (this.get(i) != 0) {
                byte currentValue = this.get(i);
                currentValue = (byte)(currentValue - 1);
                this.set(i, currentValue);
                break;
            }
            this.set(i, (byte)-1);
        }
        return this;
    }

    public MutableBytes mutableSlice(int var1, int var2);

    default public void fill(byte b) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.set(i, b);
        }
    }

    default public void clear() {
        this.fill((byte)0);
    }
}

