/*
 * Decompiled with CFR 0.152.
 */
package org.tron.tronj.crypto.tuweniTypes;

import com.google.common.base.Preconditions;
import org.tron.tronj.crypto.tuweniTypes.Bytes32;
import org.tron.tronj.crypto.tuweniTypes.DelegatingMutableBytes32;
import org.tron.tronj.crypto.tuweniTypes.MutableArrayWrappingBytes32;
import org.tron.tronj.crypto.tuweniTypes.MutableBytes;

public interface MutableBytes32
extends MutableBytes,
Bytes32 {
    public static MutableBytes32 create() {
        return new MutableArrayWrappingBytes32(new byte[32]);
    }

    public static MutableBytes32 wrap(byte[] value) {
        Preconditions.checkNotNull((Object)value);
        return new MutableArrayWrappingBytes32(value);
    }

    public static MutableBytes32 wrap(byte[] value, int offset) {
        Preconditions.checkNotNull((Object)value);
        return new MutableArrayWrappingBytes32(value, offset);
    }

    public static MutableBytes32 wrap(MutableBytes value) {
        Preconditions.checkNotNull((Object)value);
        if (value instanceof MutableBytes32) {
            return (MutableBytes32)value;
        }
        return DelegatingMutableBytes32.delegateTo(value);
    }

    public static MutableBytes32 wrap(MutableBytes value, int offset) {
        Preconditions.checkNotNull((Object)value);
        if (value instanceof MutableBytes32) {
            return (MutableBytes32)value;
        }
        MutableBytes slice = value.mutableSlice(offset, 32);
        if (slice instanceof MutableBytes32) {
            return (MutableBytes32)slice;
        }
        return DelegatingMutableBytes32.delegateTo(slice);
    }
}

