/*
 * Decompiled with CFR 0.152.
 */
package org.tron.tronj.utils;

import java.math.BigDecimal;

public final class Convert {
    private Convert() {
    }

    public static BigDecimal fromSun(String number, Unit unit) {
        return Convert.fromSun(new BigDecimal(number), unit);
    }

    public static BigDecimal fromSun(BigDecimal number, Unit unit) {
        return number.divide(unit.getSunFactor());
    }

    public static BigDecimal toSun(String number, Unit unit) {
        return Convert.toSun(new BigDecimal(number), unit);
    }

    public static BigDecimal toSun(BigDecimal number, Unit unit) {
        return number.multiply(unit.getSunFactor());
    }

    public static enum Unit {
        SUN("sun", 0),
        TRX("trx", 6);

        private String name;
        private BigDecimal sunFactor;

        private Unit(String name, int factor) {
            this.name = name;
            this.sunFactor = BigDecimal.TEN.pow(factor);
        }

        public BigDecimal getSunFactor() {
            return this.sunFactor;
        }

        public String toString() {
            return this.name;
        }

        public static Unit fromString(String name) {
            if (name != null) {
                for (Unit unit : Unit.values()) {
                    if (!name.equalsIgnoreCase(unit.name)) continue;
                    return unit;
                }
            }
            return Unit.valueOf(name);
        }
    }
}

