/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.core.conf;

import com.mysql.cj.api.conf.ModifiableProperty;
import com.mysql.cj.api.conf.PropertyDefinition;
import com.mysql.cj.api.conf.PropertySet;
import com.mysql.cj.api.conf.ReadableProperty;
import com.mysql.cj.api.conf.RuntimeProperty;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.conf.PropertyDefinitions;
import com.mysql.cj.core.exceptions.CJException;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.exceptions.PropertyNotModifiableException;
import com.mysql.cj.core.exceptions.WrongArgumentException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class DefaultPropertySet
implements PropertySet,
Serializable {
    private static final long serialVersionUID = -5156024634430650528L;
    private final Map<String, RuntimeProperty<?>> PROPERTY_NAME_TO_RUNTIME_PROPERTY = new HashMap();

    public DefaultPropertySet() {
        for (PropertyDefinition<?> pdef : PropertyDefinitions.PROPERTY_NAME_TO_PROPERTY_DEFINITION.values()) {
            this.addProperty(pdef.createRuntimeProperty());
        }
    }

    @Override
    public void addProperty(RuntimeProperty<?> prop) {
        PropertyDefinition<?> def = prop.getPropertyDefinition();
        this.PROPERTY_NAME_TO_RUNTIME_PROPERTY.put(def.getName(), prop);
        if (def.hasCcAlias()) {
            this.PROPERTY_NAME_TO_RUNTIME_PROPERTY.put(def.getCcAlias(), prop);
        }
    }

    @Override
    public void removeProperty(String name) {
        RuntimeProperty<?> prop = this.PROPERTY_NAME_TO_RUNTIME_PROPERTY.remove(name);
        if (prop != null) {
            if (!name.equals(prop.getPropertyDefinition().getName())) {
                this.PROPERTY_NAME_TO_RUNTIME_PROPERTY.remove(prop.getPropertyDefinition().getName());
            } else if (prop.getPropertyDefinition().hasCcAlias()) {
                this.PROPERTY_NAME_TO_RUNTIME_PROPERTY.remove(prop.getPropertyDefinition().getCcAlias());
            }
        }
    }

    @Override
    public <T> ReadableProperty<T> getReadableProperty(String name) {
        try {
            ReadableProperty prop = (ReadableProperty)this.PROPERTY_NAME_TO_RUNTIME_PROPERTY.get(name);
            if (prop != null) {
                return prop;
            }
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ConnectionProperties.notFound", new Object[]{name}));
        }
        catch (ClassCastException ex) {
            throw ExceptionFactory.createException(WrongArgumentException.class, ex.getMessage(), ex);
        }
    }

    @Override
    public ReadableProperty<Boolean> getBooleanReadableProperty(String name) {
        return this.getReadableProperty(name);
    }

    @Override
    public ReadableProperty<Integer> getIntegerReadableProperty(String name) {
        return this.getReadableProperty(name);
    }

    @Override
    public ReadableProperty<Long> getLongReadableProperty(String name) {
        return this.getReadableProperty(name);
    }

    @Override
    public ReadableProperty<Integer> getMemorySizeReadableProperty(String name) {
        return this.getReadableProperty(name);
    }

    @Override
    public ReadableProperty<String> getStringReadableProperty(String name) {
        return this.getReadableProperty(name);
    }

    @Override
    public <T extends Enum<T>> ReadableProperty<T> getEnumReadableProperty(String name) {
        return this.getReadableProperty(name);
    }

    @Override
    public <T> ModifiableProperty<T> getModifiableProperty(String name) {
        RuntimeProperty<?> prop = this.PROPERTY_NAME_TO_RUNTIME_PROPERTY.get(name);
        if (prop != null) {
            if (ModifiableProperty.class.isAssignableFrom(prop.getClass())) {
                try {
                    return (ModifiableProperty)this.PROPERTY_NAME_TO_RUNTIME_PROPERTY.get(name);
                }
                catch (ClassCastException ex) {
                    throw ExceptionFactory.createException(WrongArgumentException.class, ex.getMessage(), ex);
                }
            }
            throw ExceptionFactory.createException(PropertyNotModifiableException.class, Messages.getString("ConnectionProperties.dynamicChangeIsNotAllowed", new Object[]{"'" + prop.getPropertyDefinition().getName() + "'"}));
        }
        throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ConnectionProperties.notFound", new Object[]{name}));
    }

    @Override
    public ModifiableProperty<Boolean> getBooleanModifiableProperty(String name) {
        return this.getModifiableProperty(name);
    }

    @Override
    public ModifiableProperty<Integer> getIntegerModifiableProperty(String name) {
        return this.getModifiableProperty(name);
    }

    @Override
    public ModifiableProperty<Long> getLongModifiableProperty(String name) {
        return this.getModifiableProperty(name);
    }

    @Override
    public ModifiableProperty<Integer> getMemorySizeModifiableProperty(String name) {
        return this.getModifiableProperty(name);
    }

    @Override
    public ModifiableProperty<String> getStringModifiableProperty(String name) {
        return this.getModifiableProperty(name);
    }

    public <T extends Enum<T>> ModifiableProperty<T> getEnumModifiableProperty(String name) {
        return this.getModifiableProperty(name);
    }

    @Override
    public void initializeProperties(Properties props) {
        if (props != null) {
            Properties infoCopy = (Properties)props.clone();
            infoCopy.remove("HOST");
            infoCopy.remove("user");
            infoCopy.remove("password");
            infoCopy.remove("DBNAME");
            infoCopy.remove("PORT");
            for (String propName : PropertyDefinitions.PROPERTY_NAME_TO_PROPERTY_DEFINITION.keySet()) {
                try {
                    ReadableProperty propToSet = this.getReadableProperty(propName);
                    propToSet.initializeFrom(infoCopy, null);
                }
                catch (CJException e) {
                    throw ExceptionFactory.createException(WrongArgumentException.class, e.getMessage(), e);
                }
            }
            this.postInitialization();
        }
    }

    @Override
    public void postInitialization() {
    }

    @Override
    public Properties exposeAsProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        for (String propName : PropertyDefinitions.PROPERTY_NAME_TO_PROPERTY_DEFINITION.keySet()) {
            ReadableProperty propToGet = this.getReadableProperty(propName);
            String propValue = propToGet.getStringValue();
            if (propValue == null) continue;
            props.setProperty(propToGet.getPropertyDefinition().getName(), propValue);
        }
        return props;
    }
}

