/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.core.conf;

import com.mysql.cj.api.conf.ModifiableProperty;
import com.mysql.cj.api.conf.PropertyDefinition;
import com.mysql.cj.api.exceptions.ExceptionInterceptor;
import com.mysql.cj.core.conf.ReadableLongProperty;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.exceptions.WrongArgumentException;
import java.io.Serializable;

public class ModifiableLongProperty
extends ReadableLongProperty
implements ModifiableProperty<Long>,
Serializable {
    private static final long serialVersionUID = 2870949628194348648L;

    protected ModifiableLongProperty(PropertyDefinition<Long> propertyDefinition) {
        super(propertyDefinition);
    }

    @Override
    protected void initializeFrom(String extractedValue, ExceptionInterceptor exceptionInterceptor) {
        super.initializeFrom(extractedValue, exceptionInterceptor);
        this.initialValue = this.value;
    }

    @Override
    public void setFromString(String value, ExceptionInterceptor exceptionInterceptor) {
        this.setValue((Long)this.getPropertyDefinition().parseObject(value, exceptionInterceptor), value, exceptionInterceptor);
    }

    @Override
    public void setValue(Long longValue) {
        this.setValue(longValue, null, null);
    }

    @Override
    public void setValue(Long longValue, ExceptionInterceptor exceptionInterceptor) {
        this.setValue(longValue, null, exceptionInterceptor);
    }

    void setValue(long longValue, String valueAsString, ExceptionInterceptor exceptionInterceptor) {
        if (this.getPropertyDefinition().isRangeBased() && (longValue < (long)this.getPropertyDefinition().getLowerBound() || longValue > (long)this.getPropertyDefinition().getUpperBound())) {
            throw ExceptionFactory.createException(WrongArgumentException.class, "The connection property '" + this.getPropertyDefinition().getName() + "' only accepts long integer values in the range of " + this.getPropertyDefinition().getLowerBound() + " - " + this.getPropertyDefinition().getUpperBound() + ", the value '" + (valueAsString == null ? Long.valueOf(longValue) : valueAsString) + "' exceeds this range.", exceptionInterceptor);
        }
        this.value = longValue;
        this.wasExplicitlySet = true;
        this.invokeListeners();
    }

    @Override
    public void resetValue() {
        this.value = this.initialValue;
        this.invokeListeners();
    }
}

