/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.xdevapi;

import com.mysql.cj.api.xdevapi.Expression;
import com.mysql.cj.x.protobuf.MysqlxCrud;
import com.mysql.cj.xdevapi.ExprParser;
import com.mysql.cj.xdevapi.FindParams;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;

public class DocFindParams
extends FindParams {
    public DocFindParams(String schemaName, String collectionName) {
        super(schemaName, collectionName, false);
    }

    public DocFindParams(String schemaName, String collectionName, String criteriaString) {
        super(schemaName, collectionName, criteriaString, false);
    }

    private DocFindParams(MysqlxCrud.Collection coll, boolean isRelational) {
        super(coll, isRelational);
    }

    public void setFields(Expression docProjection) {
        this.fields = Collections.singletonList(MysqlxCrud.Projection.newBuilder().setSource(new ExprParser(docProjection.getExpressionString(), false).parse()).build());
    }

    @Override
    public void setFields(String ... projection) {
        this.fields = new ExprParser(Arrays.stream(projection).collect(Collectors.joining(", ")), false).parseDocumentProjection();
    }

    @Override
    public FindParams clone() {
        DocFindParams newFindParams = new DocFindParams(this.collection, this.isRelational);
        newFindParams.setLimit(this.limit);
        newFindParams.setOffset(this.offset);
        if (this.orderExpr != null) {
            newFindParams.setOrder(this.orderExpr);
        }
        if (this.criteriaStr != null) {
            newFindParams.setCriteria(this.criteriaStr);
            if (this.args != null) {
                for (int i = 0; i < this.args.length; ++i) {
                    newFindParams.args[i] = this.args[i];
                }
            }
        }
        if (this.groupBy != null) {
            newFindParams.setGrouping(this.groupBy);
        }
        if (this.having != null) {
            newFindParams.setGroupingCriteria(this.having);
        }
        if (this.lock != null) {
            newFindParams.setLock(this.lock);
        }
        return newFindParams;
    }
}

