/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.driverlaunched;

import com.mysql.jdbc.SocketFactory;
import com.mysql.jdbc.StandardSocketFactory;
import com.mysql.management.MysqldFactory;
import com.mysql.management.MysqldResourceI;
import com.mysql.management.MysqldResourceTestImpl;
import com.mysql.management.driverlaunched.ServerLauncherSocketFactory;
import com.mysql.management.util.Files;
import java.io.File;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;

public class ServerLauncherSocketFactoryTest
extends TestCase {
    private String orig;

    protected void setUp() {
        this.orig = System.getProperty("c-mxj.files.use-test-dir");
        System.setProperty("c-mxj.files.use-test-dir", Boolean.TRUE.toString());
    }

    protected void tearDown() {
        if (this.orig != null) {
            System.setProperty("c-mxj.files.use-test-dir", this.orig);
        } else {
            System.setProperty("c-mxj.files.use-test-dir", "");
        }
    }

    public void testReplaceNullStringWithNull() {
        ServerLauncherSocketFactory sf = new ServerLauncherSocketFactory();
        ServerLauncherSocketFactoryTest.assertEquals(null, (String)sf.replaceNullStringWithNull("null"));
        ServerLauncherSocketFactoryTest.assertEquals(null, (String)sf.replaceNullStringWithNull(null));
        ServerLauncherSocketFactoryTest.assertEquals((String)"foo", (String)sf.replaceNullStringWithNull("foo"));
    }

    public void testDefaultConstruction() {
        ServerLauncherSocketFactory sf = new ServerLauncherSocketFactory();
        ServerLauncherSocketFactoryTest.assertEquals(StandardSocketFactory.class, sf.getSocketFactory().getClass());
        ServerLauncherSocketFactoryTest.assertEquals(MysqldFactory.Default.class, sf.getResourceFactory().getClass());
    }

    public void testComposition() throws Exception, Exception {
        ServerLauncherSocketFactory sf = new ServerLauncherSocketFactory();
        FakeSocketFactory fake = new FakeSocketFactory();
        sf.setSocketFactory(fake);
        sf.throwOnBadPassword(false);
        sf.setResourceFactory(new FakeMysqldFactory());
        ServerLauncherSocketFactoryTest.assertEquals((int)0, (int)fake.connectCalled);
        ServerLauncherSocketFactoryTest.assertEquals((int)0, (int)fake.beforeHandshakeCalled);
        ServerLauncherSocketFactoryTest.assertEquals((int)0, (int)fake.afterHandshakeCalled);
        sf.connect(null, 0, new Properties());
        ServerLauncherSocketFactoryTest.assertEquals((int)1, (int)fake.connectCalled);
        ServerLauncherSocketFactoryTest.assertEquals((int)0, (int)fake.beforeHandshakeCalled);
        ServerLauncherSocketFactoryTest.assertEquals((int)0, (int)fake.afterHandshakeCalled);
        sf.beforeHandshake();
        ServerLauncherSocketFactoryTest.assertEquals((int)1, (int)fake.connectCalled);
        ServerLauncherSocketFactoryTest.assertEquals((int)1, (int)fake.beforeHandshakeCalled);
        ServerLauncherSocketFactoryTest.assertEquals((int)0, (int)fake.afterHandshakeCalled);
        sf.afterHandshake();
        ServerLauncherSocketFactoryTest.assertEquals((int)1, (int)fake.connectCalled);
        ServerLauncherSocketFactoryTest.assertEquals((int)1, (int)fake.beforeHandshakeCalled);
        ServerLauncherSocketFactoryTest.assertEquals((int)1, (int)fake.afterHandshakeCalled);
    }

    public void testMultipleConnectionsAndShutdownListener() throws Exception {
        ServerLauncherSocketFactory sf = new ServerLauncherSocketFactory();
        FakeMysqldFactory factory = new FakeMysqldFactory();
        sf.setResourceFactory(factory);
        sf.setSocketFactory(new FakeSocketFactory());
        sf.throwOnBadPassword(false);
        ServerLauncherSocketFactoryTest.assertEquals((int)0, (int)factory.fakeRunningMysqlds.size());
        String host = "localhost";
        int port = 3306;
        File baseDir = new Files().tmp("mysql-c.mxj");
        Properties props = new Properties();
        props.setProperty("foo", "bar");
        props.setProperty("server.basedir", baseDir.toString());
        props.setProperty("server.baz", "wiz");
        props.setProperty("server.nullMe", "null");
        ServerLauncherSocketFactoryTest.assertEquals((int)0, (int)factory.fakeRunningMysqlds.size());
        sf.connect(host, port, props);
        ServerLauncherSocketFactoryTest.assertEquals((int)1, (int)factory.fakeRunningMysqlds.size());
        MysqldResourceI mysqldResource = (MysqldResourceI)factory.fakeRunningMysqlds.get(baseDir);
        Map serverParams = mysqldResource.getServerOptions();
        ServerLauncherSocketFactoryTest.assertEquals((Object)"wiz", serverParams.get("baz"));
        ServerLauncherSocketFactoryTest.assertFalse((String)"wiz", (boolean)serverParams.containsKey("foo"));
        ServerLauncherSocketFactoryTest.assertTrue((String)"nullMe", (boolean)serverParams.containsKey("nullMe"));
        ServerLauncherSocketFactoryTest.assertEquals(null, serverParams.get("nullMe"));
        sf.connect(host, port, props);
        ServerLauncherSocketFactoryTest.assertEquals((int)1, (int)factory.fakeRunningMysqlds.size());
        props.setProperty("server.basedir", baseDir.toString() + "2");
        sf.connect(host, port + 1, props);
        ServerLauncherSocketFactoryTest.assertEquals((int)2, (int)factory.fakeRunningMysqlds.size());
        mysqldResource.shutdown();
        ServerLauncherSocketFactoryTest.assertEquals((int)1, (int)factory.fakeRunningMysqlds.size());
    }

    public void testDefaultAnd3306() throws Exception {
        ServerLauncherSocketFactory sf = new ServerLauncherSocketFactory();
        FakeMysqldFactory factory = new FakeMysqldFactory();
        FakeSocketFactory fakeSf = new FakeSocketFactory();
        sf.setResourceFactory(factory);
        sf.setSocketFactory(fakeSf);
        sf.throwOnBadPassword(false);
        Properties props = new Properties();
        int port = 3306;
        ServerLauncherSocketFactoryTest.assertEquals((int)0, (int)factory.fakeRunningMysqlds.size());
        sf.connect("localhost", port, props);
        ServerLauncherSocketFactoryTest.assertEquals((int)1, (int)factory.fakeRunningMysqlds.size());
        sf.connect("127.0.0.1", port, props);
        ServerLauncherSocketFactoryTest.assertEquals((int)1, (int)factory.fakeRunningMysqlds.size());
        File baseDir = new Files().tmp("MysqlDir3307");
        props.setProperty("server.basedir", baseDir.toString() + "1");
        sf.connect("localhost", port + 1, props);
        ServerLauncherSocketFactoryTest.assertEquals((int)2, (int)factory.fakeRunningMysqlds.size());
    }

    static class FakeSocketFactory
    implements SocketFactory {
        int afterHandshakeCalled = 0;
        int beforeHandshakeCalled = 0;
        int connectCalled = 0;
        Object[] connectInfo;

        FakeSocketFactory() {
        }

        public Socket afterHandshake() {
            ++this.afterHandshakeCalled;
            return null;
        }

        public Socket beforeHandshake() {
            ++this.beforeHandshakeCalled;
            return null;
        }

        public Socket connect(String host, int portNumber, Properties props) {
            this.connectInfo = new Object[]{host, new Integer(portNumber), props};
            ++this.connectCalled;
            return null;
        }
    }

    static class FakeMysqldFactory
    implements MysqldFactory {
        Map fakeRunningMysqlds = new HashMap();

        @Override
        public MysqldResourceI newMysqldResource(File base, File data, String version) {
            return new MysqldResourceTestImpl(base, data, this.fakeRunningMysqlds);
        }
    }
}

