/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.Exceptions;
import com.mysql.management.util.NotImplementedException;
import com.mysql.management.util.RuntimeI;
import com.mysql.management.util.StreamConnector;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public interface Shell
extends Runnable {
    public void setEnvironment(String[] var1);

    public void setWorkingDir(File var1);

    public void addCompletionListener(Runnable var1);

    public int returnCode();

    public boolean hasReturned();

    public void destroyProcess();

    public String getName();

    public boolean isAlive();

    public boolean isDaemon();

    public void setDaemon(boolean var1);

    public void join();

    public void start();

    public static class Stub
    implements Shell {
        @Override
        public void addCompletionListener(Runnable listener) {
            throw new NotImplementedException(listener);
        }

        @Override
        public void destroyProcess() {
            throw new NotImplementedException();
        }

        @Override
        public String getName() {
            throw new NotImplementedException();
        }

        @Override
        public boolean hasReturned() {
            throw new NotImplementedException();
        }

        @Override
        public boolean isAlive() {
            throw new NotImplementedException();
        }

        @Override
        public boolean isDaemon() {
            throw new NotImplementedException();
        }

        @Override
        public void join() {
            throw new NotImplementedException();
        }

        @Override
        public int returnCode() {
            throw new NotImplementedException();
        }

        @Override
        public void run() {
            throw new NotImplementedException();
        }

        @Override
        public void setDaemon(boolean val) {
            throw new NotImplementedException(new Boolean(val));
        }

        @Override
        public void setEnvironment(String[] envp) {
            throw new NotImplementedException(envp);
        }

        @Override
        public void setWorkingDir(File workingDir) {
            throw new NotImplementedException(workingDir);
        }

        @Override
        public void start() {
            throw new NotImplementedException();
        }
    }

    public static final class Default
    implements Shell {
        private Thread me;
        private String[] args;
        private String[] envp;
        private File workingDir;
        private PrintStream out;
        private PrintStream err;
        private Integer returnCode;
        private Process p;
        private List listeners;
        private Exceptions exceptions;
        private RuntimeI runtime;

        public Default(String[] args, String name, PrintStream out, PrintStream err) {
            this.me = new Thread((Runnable)this, name);
            this.args = args;
            this.out = out;
            this.err = err;
            this.envp = null;
            this.workingDir = null;
            this.returnCode = null;
            this.listeners = new ArrayList();
            this.exceptions = new Exceptions();
            this.runtime = new RuntimeI.Default();
        }

        @Override
        public void setEnvironment(String[] envp) {
            this.envp = envp;
        }

        @Override
        public void setWorkingDir(File workingDir) {
            this.workingDir = workingDir;
        }

        void setRuntime(RuntimeI runtime) {
            this.runtime = runtime;
        }

        @Override
        public void run() {
            if (this.p != null) {
                throw new IllegalStateException("Process already running");
            }
            try {
                this.returnCode = null;
                this.p = this.runtime.exec(this.args, this.envp, this.workingDir);
                this.captureStdOutAndStdErr();
                this.returnCode = new Integer(this.p.waitFor());
            }
            catch (Exception e) {
                throw this.exceptions.toRuntime(e);
            }
            finally {
                this.p = null;
                for (int i = 0; i < this.listeners.size(); ++i) {
                    new Thread((Runnable)this.listeners.get(i)).start();
                }
                this.listeners.clear();
            }
        }

        private void captureStdOutAndStdErr() {
            InputStream pOut = this.p.getInputStream();
            InputStream pErr = this.p.getErrorStream();
            new StreamConnector(pOut, this.out, this.getName() + " std out").start();
            new StreamConnector(pErr, this.err, this.getName() + " std err").start();
        }

        @Override
        public void addCompletionListener(Runnable listener) {
            if (listener == null) {
                throw new IllegalArgumentException("Listener is null");
            }
            this.listeners.add(listener);
        }

        @Override
        public int returnCode() {
            if (!this.hasReturned()) {
                throw new RuntimeException("Process hasn't returned yet");
            }
            return this.returnCode;
        }

        @Override
        public boolean hasReturned() {
            return this.returnCode != null;
        }

        @Override
        public void destroyProcess() {
            if (this.p != null) {
                this.p.destroy();
            }
        }

        @Override
        public String getName() {
            return this.me.getName();
        }

        @Override
        public boolean isAlive() {
            return this.me.isAlive();
        }

        @Override
        public boolean isDaemon() {
            return this.me.isDaemon();
        }

        @Override
        public void setDaemon(boolean val) {
            this.me.setDaemon(val);
        }

        @Override
        public void join() {
            new Exceptions.VoidBlock(){

                @Override
                protected void inner() throws InterruptedException {
                    Default.this.me.join();
                }
            }.exec();
        }

        @Override
        public void start() {
            this.me.start();
        }
    }

    public static class Factory {
        public Shell newShell(String[] args, String name, PrintStream out, PrintStream err) {
            return new Default(args, name, out, err);
        }
    }
}

