/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.Period;
import net.bull.javamelody.Range;

class HttpCookieManager {
    private static final String PERIOD_COOKIE_NAME = "javamelody.period";
    private static Range defaultRange = Period.JOUR.getRange();

    HttpCookieManager() {
    }

    Range getRange(HttpServletRequest req, HttpServletResponse resp) {
        Range range;
        if (req.getParameter("period") == null) {
            Cookie cookie = this.getCookieByName(req, PERIOD_COOKIE_NAME);
            range = cookie == null ? defaultRange : Range.parse(cookie.getValue());
        } else {
            range = Range.parse(req.getParameter("period"));
            this.addCookie(req, resp, PERIOD_COOKIE_NAME, range.getValue());
        }
        return range;
    }

    Cookie getCookieByName(HttpServletRequest req, String cookieName) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookieName.equals(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    void addCookie(HttpServletRequest req, HttpServletResponse resp, String cookieName, String cookieValue) {
        if (!"added".equals(req.getAttribute(cookieName))) {
            Cookie cookie = new Cookie(cookieName, cookieValue);
            cookie.setMaxAge(2592000);
            cookie.setPath(req.getRequestURI());
            resp.addCookie(cookie);
            req.setAttribute(cookieName, (Object)"added");
        }
    }

    String getCookiesAsString(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                sb.append(cookie.getName()).append('=').append(cookie.getValue());
                if (i >= cookies.length - 1) continue;
                sb.append("; ");
            }
            return sb.toString();
        }
        return null;
    }

    static void setDefaultRange(Range range) {
        defaultRange = range;
    }
}

