/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.InputStream;
import java.io.Serializable;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

public class HeapHistogram
implements Serializable {
    private static final long serialVersionUID = 2163916067335213382L;
    private final List<ClassInfo> classes;
    private final List<ClassInfo> permGenClasses;
    private final Date time = new Date();
    private long totalHeapBytes;
    private long totalHeapInstances;
    private long totalPermGenBytes;
    private long totalPermgenInstances;
    private boolean sourceDisplayed;
    private boolean deltaDisplayed;

    public HeapHistogram(InputStream in, boolean jrockit) {
        Scanner sc = new Scanner(in, "UTF-8");
        List<ClassInfo> classInfos = this.scan(sc, jrockit);
        this.classes = new ArrayList<ClassInfo>();
        this.permGenClasses = new ArrayList<ClassInfo>();
        for (ClassInfo classInfo : classInfos) {
            if (classInfo.isPermGen()) {
                this.permGenClasses.add(classInfo);
                this.totalPermGenBytes += classInfo.getBytes();
                this.totalPermgenInstances += classInfo.getInstancesCount();
            } else {
                this.classes.add(classInfo);
                this.totalHeapBytes += classInfo.getBytes();
                this.totalHeapInstances += classInfo.getInstancesCount();
            }
            if (this.sourceDisplayed || classInfo.getSource() == null) continue;
            this.sourceDisplayed = true;
        }
        if (!jrockit) {
            sc.next("Total");
            long totalInstances = sc.nextLong();
            long totalBytes = sc.nextLong();
            assert (totalInstances == this.totalPermgenInstances + this.totalHeapInstances);
            assert (totalBytes == this.totalPermGenBytes + this.totalHeapBytes);
        }
        this.sort();
    }

    public void add(HeapHistogram second) {
        HashMap<String, ClassInfo> classesMap = new HashMap<String, ClassInfo>(1024);
        HashMap<String, ClassInfo> permGenMap = new HashMap<String, ClassInfo>(1024);
        for (ClassInfo classInfo : this.classes) {
            this.addClassInfo(classInfo, classesMap);
        }
        for (ClassInfo classInfo : this.permGenClasses) {
            this.addClassInfo(classInfo, permGenMap);
        }
        for (ClassInfo classInfo : second.getHeapHistogram()) {
            this.addClassInfo(classInfo, classesMap);
        }
        for (ClassInfo classInfo : second.getPermGenHistogram()) {
            this.addClassInfo(classInfo, permGenMap);
        }
        this.totalHeapBytes += second.getTotalHeapBytes();
        this.totalHeapInstances += second.getTotalHeapInstances();
        this.totalPermGenBytes += second.getTotalPermGenBytes();
        this.totalPermgenInstances += second.getTotalPermGenInstances();
        this.classes.clear();
        this.classes.addAll(classesMap.values());
        this.permGenClasses.clear();
        this.permGenClasses.addAll(permGenMap.values());
        this.sort();
        this.sourceDisplayed = this.sourceDisplayed || second.isSourceDisplayed();
    }

    private void addClassInfo(ClassInfo newClInfo, Map<String, ClassInfo> map) {
        ClassInfo oldClInfo = map.get(newClInfo.getName());
        if (oldClInfo == null) {
            map.put(newClInfo.getName(), newClInfo);
        } else {
            oldClInfo.add(newClInfo);
        }
    }

    public Date getTime() {
        return this.time;
    }

    public List<ClassInfo> getHeapHistogram() {
        return Collections.unmodifiableList(this.classes);
    }

    public long getTotalHeapInstances() {
        return this.totalHeapInstances;
    }

    public long getTotalHeapBytes() {
        return this.totalHeapBytes;
    }

    public List<ClassInfo> getPermGenHistogram() {
        return Collections.unmodifiableList(this.permGenClasses);
    }

    public long getTotalPermGenInstances() {
        return this.totalPermgenInstances;
    }

    public long getTotalPermGenBytes() {
        return this.totalPermGenBytes;
    }

    public boolean isSourceDisplayed() {
        return this.sourceDisplayed;
    }

    @Deprecated
    boolean isDeltaDisplayed() {
        return this.deltaDisplayed;
    }

    private void sort() {
        Comparator<ClassInfo> classInfoReversedComparator = Collections.reverseOrder(new ClassInfoComparator());
        Collections.sort(this.permGenClasses, classInfoReversedComparator);
        Collections.sort(this.classes, classInfoReversedComparator);
    }

    private void skipHeader(Scanner sc, boolean jrockit) {
        String nextLine = sc.nextLine();
        if (nextLine.isEmpty()) {
            sc.nextLine();
        }
        if (!jrockit) {
            sc.skip("-+");
            sc.nextLine();
        }
    }

    private List<ClassInfo> scan(Scanner sc, boolean jrockit) {
        HashMap<String, ClassInfo> classInfoMap = new HashMap<String, ClassInfo>(1024);
        sc.useRadix(10);
        this.skipHeader(sc, jrockit);
        String nextLine = jrockit ? "[0-9.]+%" : "[0-9]+:";
        while (sc.hasNext(nextLine)) {
            ClassInfo newClInfo = new ClassInfo(sc, jrockit);
            this.addClassInfo(newClInfo, classInfoMap);
        }
        return new ArrayList<ClassInfo>(classInfoMap.values());
    }

    public static class ClassInfo
    implements Serializable {
        private static final long serialVersionUID = 6283636454450216347L;
        private static Map<Character, String> arrayTypes = new HashMap<Character, String>();
        private long instances;
        private long bytes;
        private final String jvmName;
        private final String name;
        private final boolean permGen;
        private final String source;

        ClassInfo(Scanner sc, boolean jrockit) {
            sc.next();
            if (jrockit) {
                this.bytes = ClassInfo.parseLongWithK(sc.next());
                this.instances = sc.nextLong();
            } else {
                this.instances = sc.nextLong();
                this.bytes = sc.nextLong();
            }
            this.jvmName = sc.next();
            this.permGen = this.jvmName.charAt(0) == '<';
            this.name = this.convertJVMName();
            this.source = this.findSource();
            if (sc.hasNext("\\([a-zA-Z.@0-9]*\\)")) {
                sc.next();
            }
        }

        void add(ClassInfo classInfo) {
            assert (this.getName().equals(classInfo.getName()));
            this.bytes += classInfo.getBytes();
            this.instances += classInfo.getInstancesCount();
        }

        public String getName() {
            return this.name;
        }

        public long getInstancesCount() {
            return this.instances;
        }

        public long getBytes() {
            return this.bytes;
        }

        boolean isPermGen() {
            return this.permGen;
        }

        public String getSource() {
            return this.source;
        }

        private String findSource() {
            if (this.jvmName.endsWith("Klass>") || this.jvmName.startsWith("sun.reflect.")) {
                return null;
            }
            try {
                Class<?> clazz = Class.forName(this.jvmName);
                return ClassInfo.findSource(clazz);
            }
            catch (LinkageError e) {
                return null;
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        private static String findSource(Class<?> clazz) {
            CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
            if (codeSource != null && codeSource.getLocation() != null) {
                String src = codeSource.getLocation().toString();
                if (src.startsWith("file:/")) {
                    src = src.substring("file:/".length());
                } else if (src.startsWith("vfs:/")) {
                    src = src.substring("vfs:/".length());
                } else if (src.startsWith("reference:file:/")) {
                    src = src.substring("reference:file:/".length());
                }
                if (src.endsWith(".jar") || src.endsWith(".war")) {
                    src = src.intern();
                }
                return src;
            }
            return null;
        }

        private String convertJVMName() {
            String result;
            int index = this.jvmName.lastIndexOf(91);
            if (index != -1) {
                char code = this.jvmName.charAt(index + 1);
                if (code == 'L') {
                    result = this.jvmName.substring(index + 2, this.jvmName.length() - 1);
                } else {
                    result = arrayTypes.get(Character.valueOf(code));
                    if (result == null) {
                        result = this.jvmName;
                    }
                }
                StringBuilder sb = new StringBuilder(result);
                for (int i = 0; i <= index; ++i) {
                    sb.append("[]");
                }
                result = sb.toString();
            } else {
                result = this.jvmName;
            }
            return result.intern();
        }

        public static long parseLongWithK(String text) {
            assert (!text.isEmpty());
            if (text.charAt(text.length() - 1) == 'k') {
                String t = text.substring(0, text.length() - 1);
                if (t.charAt(0) == '+') {
                    t = t.substring(1);
                }
                return 1024L * Long.parseLong(t);
            }
            return Long.parseLong(text);
        }

        static {
            arrayTypes.put(Character.valueOf('Z'), "boolean");
            arrayTypes.put(Character.valueOf('C'), "char");
            arrayTypes.put(Character.valueOf('B'), "byte");
            arrayTypes.put(Character.valueOf('S'), "short");
            arrayTypes.put(Character.valueOf('I'), "int");
            arrayTypes.put(Character.valueOf('J'), "long");
            arrayTypes.put(Character.valueOf('F'), "float");
            arrayTypes.put(Character.valueOf('D'), "double");
            arrayTypes.put(Character.valueOf('L'), "object");
        }
    }

    static final class ClassInfoComparator
    implements Comparator<ClassInfo>,
    Serializable {
        private static final long serialVersionUID = 1L;

        ClassInfoComparator() {
        }

        @Override
        public int compare(ClassInfo classInfo1, ClassInfo classInfo2) {
            if (classInfo1.getBytes() > classInfo2.getBytes()) {
                return 1;
            }
            if (classInfo1.getBytes() < classInfo2.getBytes()) {
                return -1;
            }
            return 0;
        }
    }
}

