/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.filters;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import net.coobird.thumbnailator.builders.BufferedImageBuilder;
import net.coobird.thumbnailator.filters.ImageFilter;
import net.coobird.thumbnailator.util.BufferedImages;

public class Rotation {
    public static final Rotator LEFT_90_DEGREES = Rotation.newRotator(-90.0);
    public static final Rotator RIGHT_90_DEGREES = Rotation.newRotator(90.0);
    public static final Rotator ROTATE_180_DEGREES = Rotation.newRotator(180.0);

    private Rotation() {
    }

    public static Rotator newRotator(final double d) {
        Rotator rotator = new Rotator(){

            private double[] calculatePosition(double d6, double d2, double d3) {
                d3 = Math.toRadians(d3);
                double d4 = Math.cos(d3) * d6 - Math.sin(d3) * d2;
                double d5 = Math.sin(d3) * d6 + Math.cos(d3) * d2;
                return new double[]{d4, d5};
            }

            public BufferedImage apply(BufferedImage bufferedImage) {
                int n = bufferedImage.getWidth();
                int n2 = bufferedImage.getHeight();
                double[][] dArrayArray = new double[][]{this.calculatePosition(0.0, 0.0, d), this.calculatePosition(n, 0.0, d), this.calculatePosition(0.0, n2, d), this.calculatePosition(n, n2, d)};
                double d7 = Math.min(Math.min(dArrayArray[0][0], dArrayArray[1][0]), Math.min(dArrayArray[2][0], dArrayArray[3][0]));
                double d2 = Math.max(Math.max(dArrayArray[0][0], dArrayArray[1][0]), Math.max(dArrayArray[2][0], dArrayArray[3][0]));
                double d3 = Math.min(Math.min(dArrayArray[0][1], dArrayArray[1][1]), Math.min(dArrayArray[2][1], dArrayArray[3][1]));
                double d4 = Math.max(Math.max(dArrayArray[0][1], dArrayArray[1][1]), Math.max(dArrayArray[2][1], dArrayArray[3][1]));
                int n3 = (int)Math.round(d2 - d7);
                int n4 = (int)Math.round(d4 - d3);
                BufferedImage bufferedImage2 = new BufferedImageBuilder(n3, n4).build();
                Graphics2D graphics2D = bufferedImage2.createGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                double d5 = (double)n3 / 2.0;
                double d6 = (double)n4 / 2.0;
                graphics2D.rotate(Math.toRadians(d), d5, d6);
                int n5 = (int)Math.round((double)(n3 - n) / 2.0);
                int n6 = (int)Math.round((double)(n4 - n2) / 2.0);
                graphics2D.drawImage((Image)bufferedImage, n5, n6, null);
                graphics2D.dispose();
                if (bufferedImage.getType() != bufferedImage2.getType()) {
                    return BufferedImages.copy(bufferedImage2, bufferedImage.getType());
                }
                return bufferedImage2;
            }
        };
        return rotator;
    }

    public static abstract class Rotator
    implements ImageFilter {
        private Rotator() {
        }
    }
}

