/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.geometry;

import java.awt.Dimension;
import net.coobird.thumbnailator.geometry.Size;

public class RelativeSize
implements Size {
    private final double scalingFactor;

    public RelativeSize(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("The scaling factor must be between 0.0d and 1.0d, inclusive.");
        }
        this.scalingFactor = d;
    }

    public Dimension calculate(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Width and height must be greater than 0.");
        }
        int n3 = (int)Math.round((double)n * this.scalingFactor);
        int n4 = (int)Math.round((double)n2 * this.scalingFactor);
        return new Dimension(n3, n4);
    }

    public String toString() {
        return "RelativeSize [scalingFactor=" + this.scalingFactor + "]";
    }
}

