/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.cloud.commons.ip;

import java.util.Collection;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import net.guerlab.cloud.commons.ip.IpAddress;
import net.guerlab.cloud.commons.ip.IpParser;
import net.guerlab.cloud.commons.ip.IpSingleAddress;
import net.guerlab.cloud.commons.ip.Ipv4;
import net.guerlab.cloud.commons.ip.Ipv4Address;
import net.guerlab.cloud.commons.ip.Ipv4Utils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.lang.Nullable;

public class IpUtils {
    public static final String UNKNOWN = "unknown";
    public static final char SPLIT = ',';
    private static final String[] HEADERS = new String[]{"X-Forwarded-For", "Cdn-Src-Ip", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR", "X-Real-IP"};
    private static final Collection<IpParser> IP_PARSERS = ServiceLoader.load(IpParser.class).stream().map(ServiceLoader.Provider::get).collect(Collectors.toList());

    private IpUtils() {
    }

    public static boolean inList(@Nullable Collection<String> ips, @Nullable String targetIp) {
        if (ips == null || ips.isEmpty() || targetIp == null) {
            return false;
        }
        IpSingleAddress target = IpUtils.parseIpSingleAddress(targetIp);
        if (target == null) {
            return false;
        }
        Collection ranges = ips.stream().map(IpUtils::parseIpRangeAddress).filter(Objects::nonNull).collect(Collectors.toList());
        if (ranges.isEmpty()) {
            return false;
        }
        return ranges.stream().anyMatch(range -> range.contains(target));
    }

    @Nullable
    private static IpSingleAddress parseIpSingleAddress(String ip) {
        try {
            if (Ipv4Utils.isIpv4(ip)) {
                return new Ipv4Address(ip);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private static IpAddress parseIpRangeAddress(String ip) {
        try {
            if (Ipv4Utils.isIpv4(ip)) {
                return IpUtils.parseIpv4(ip);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getIp(Object request) {
        for (IpParser parser : IP_PARSERS) {
            String ip;
            if (!parser.accept(request)) continue;
            for (String headerName : HEADERS) {
                ip = IpUtils.getIpByHeader(parser.getIpByHeader(request, headerName));
                if (ip == null) continue;
                return ip;
            }
            ip = parser.getIpByRemoteAddress(request);
            if (ip == null) continue;
            return ip;
        }
        return UNKNOWN;
    }

    @Nullable
    private static String getIpByHeader(@Nullable String value) {
        if (IpUtils.isInvalidIp(value)) {
            return null;
        }
        int index = value.indexOf(44);
        if (index != -1) {
            return value.substring(0, index).trim();
        }
        return value;
    }

    public static boolean isInvalidIp(@Nullable String ip) {
        return ip == null || StringUtils.isBlank((CharSequence)ip) || UNKNOWN.equalsIgnoreCase(ip);
    }

    public static Ipv4 parseIpv4(long address) {
        return Ipv4Utils.parseIpv4(address);
    }

    public static Ipv4 parseIpv4(String address) {
        return Ipv4Utils.parseIpv4(address);
    }

    public static long calculationIpv4Mask(long startAddress, long endAddress) {
        return Ipv4Utils.calculationIpv4Mask(startAddress, endAddress);
    }

    public static String convertIpv4String(long ipAddress) {
        return Ipv4Utils.convertIpv4String(ipAddress);
    }

    public static long parseIpv4Address(String ipAddressStr) {
        return Ipv4Utils.parseIpv4Address(ipAddressStr);
    }
}

