/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.cloud.commons.ip;

import java.util.Objects;
import net.guerlab.cloud.commons.ip.IpSingleAddress;
import net.guerlab.cloud.commons.ip.IpType;
import net.guerlab.cloud.commons.ip.IpUtils;
import net.guerlab.cloud.commons.ip.Ipv4;

public class Ipv4Address
implements Ipv4,
IpSingleAddress {
    private static final IpType IP_TYPE = IpType.IPV4;
    private final long ipAddress;

    Ipv4Address(String ipAddressStr) {
        this(IpUtils.parseIpv4Address(ipAddressStr));
    }

    Ipv4Address(long address) {
        this.ipAddress = address;
    }

    @Override
    public IpType getIpType() {
        return IP_TYPE;
    }

    @Override
    public long getStartAddress() {
        return this.ipAddress;
    }

    @Override
    public long getEndAddress() {
        return this.getStartAddress();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ipv4Address that = (Ipv4Address)o;
        return this.ipAddress == that.ipAddress;
    }

    public int hashCode() {
        return Objects.hashCode(this.ipAddress);
    }

    public String toString() {
        return IpUtils.convertIpv4String(this.ipAddress);
    }

    @Override
    public long getIpAddress() {
        return this.ipAddress;
    }
}

