/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.filters;

import com.google.common.collect.ImmutableList;
import com.google.common.io.BaseEncoding;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.lightbody.bmp.core.har.Har;
import net.lightbody.bmp.core.har.HarCookie;
import net.lightbody.bmp.core.har.HarEntry;
import net.lightbody.bmp.core.har.HarNameValuePair;
import net.lightbody.bmp.core.har.HarPostData;
import net.lightbody.bmp.core.har.HarPostDataParam;
import net.lightbody.bmp.core.har.HarRequest;
import net.lightbody.bmp.core.har.HarResponse;
import net.lightbody.bmp.exception.UnsupportedCharsetException;
import net.lightbody.bmp.filters.ClientRequestCaptureFilter;
import net.lightbody.bmp.filters.HttpConnectHarCaptureFilter;
import net.lightbody.bmp.filters.HttpsAwareFiltersAdapter;
import net.lightbody.bmp.filters.ResolvedHostnameCacheFilter;
import net.lightbody.bmp.filters.ServerResponseCaptureFilter;
import net.lightbody.bmp.filters.support.HttpConnectTiming;
import net.lightbody.bmp.filters.util.HarCaptureUtil;
import net.lightbody.bmp.proxy.CaptureType;
import net.lightbody.bmp.util.BrowserMobHttpUtil;
import org.littleshoot.proxy.impl.ProxyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HarCaptureFilter
extends HttpsAwareFiltersAdapter {
    private static final Logger log = LoggerFactory.getLogger(HarCaptureFilter.class);
    private final Har har;
    private final HarEntry harEntry;
    private final ClientRequestCaptureFilter requestCaptureFilter;
    private final ServerResponseCaptureFilter responseCaptureFilter;
    private final EnumSet<CaptureType> dataToCapture;
    private volatile long dnsResolutionStartedNanos;
    private volatile long connectionQueuedNanos;
    private volatile long connectionStartedNanos;
    private volatile long sendStartedNanos;
    private volatile long sendFinishedNanos;
    private volatile long responseReceiveStartedNanos;
    private final InetSocketAddress clientAddress;
    private final AtomicInteger requestBodySize = new AtomicInteger(0);
    private final AtomicInteger responseBodySize = new AtomicInteger(0);
    private volatile HttpRequest capturedOriginalRequest;
    private volatile boolean addressResolved = false;

    public HarCaptureFilter(HttpRequest originalRequest, ChannelHandlerContext ctx, Har har, String currentPageRef, Set<CaptureType> dataToCapture) {
        super(originalRequest, ctx);
        if (har == null) {
            throw new IllegalStateException("Attempted har capture when har is null");
        }
        if (ProxyUtils.isCONNECT((HttpObject)originalRequest)) {
            throw new IllegalStateException("Attempted har capture for HTTP CONNECT request");
        }
        this.clientAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        this.dataToCapture = dataToCapture != null && !dataToCapture.isEmpty() ? EnumSet.copyOf(dataToCapture) : EnumSet.noneOf(CaptureType.class);
        this.requestCaptureFilter = this.dataToCapture.contains((Object)CaptureType.REQUEST_CONTENT) || this.dataToCapture.contains((Object)CaptureType.REQUEST_BINARY_CONTENT) ? new ClientRequestCaptureFilter(originalRequest) : null;
        this.responseCaptureFilter = this.dataToCapture.contains((Object)CaptureType.RESPONSE_CONTENT) || this.dataToCapture.contains((Object)CaptureType.RESPONSE_BINARY_CONTENT) ? new ServerResponseCaptureFilter(originalRequest, true) : null;
        this.har = har;
        this.harEntry = new HarEntry(currentPageRef);
    }

    public HttpResponse clientToProxyRequest(HttpObject httpObject) {
        if (this.requestCaptureFilter != null) {
            this.requestCaptureFilter.clientToProxyRequest(httpObject);
        }
        if (httpObject instanceof HttpRequest) {
            HttpRequest httpRequest;
            this.harEntry.setStartedDateTime(new Date());
            this.har.getLog().addEntry(this.harEntry);
            this.capturedOriginalRequest = httpRequest = (HttpRequest)httpObject;
            HarRequest request = this.createHarRequestForHttpRequest(httpRequest);
            this.harEntry.setRequest(request);
            HarResponse defaultHarResponse = HarCaptureUtil.createHarResponseForFailure();
            defaultHarResponse.setError(HarCaptureUtil.getNoResponseReceivedErrorMessage());
            this.harEntry.setResponse(defaultHarResponse);
            this.captureQueryParameters(httpRequest);
            this.captureRequestHeaderSize(httpRequest);
            if (this.dataToCapture.contains((Object)CaptureType.REQUEST_COOKIES)) {
                this.captureRequestCookies(httpRequest);
            }
            if (this.dataToCapture.contains((Object)CaptureType.REQUEST_HEADERS)) {
                this.captureRequestHeaders(httpRequest);
            }
            this.captureConnectTiming();
        }
        if (httpObject instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)httpObject;
            this.captureRequestSize(httpContent);
        }
        if (httpObject instanceof LastHttpContent) {
            LastHttpContent lastHttpContent = (LastHttpContent)httpObject;
            if (this.dataToCapture.contains((Object)CaptureType.REQUEST_HEADERS)) {
                this.captureTrailingHeaders(lastHttpContent);
            }
            if (this.dataToCapture.contains((Object)CaptureType.REQUEST_CONTENT)) {
                this.captureRequestContent(this.requestCaptureFilter.getHttpRequest(), this.requestCaptureFilter.getFullRequestContents());
            }
            this.harEntry.getRequest().setBodySize(this.requestBodySize.get());
        }
        return null;
    }

    public HttpObject serverToProxyResponse(HttpObject httpObject) {
        if (this.responseCaptureFilter != null) {
            this.responseCaptureFilter.serverToProxyResponse(httpObject);
        }
        if (httpObject instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)httpObject;
            this.captureResponse(httpResponse);
        }
        if (httpObject instanceof HttpContent) {
            HttpContent httpContent = (HttpContent)httpObject;
            this.captureResponseSize(httpContent);
        }
        if (httpObject instanceof LastHttpContent) {
            if (this.dataToCapture.contains((Object)CaptureType.RESPONSE_CONTENT)) {
                this.captureResponseContent(this.responseCaptureFilter.getHttpResponse(), this.responseCaptureFilter.getFullResponseContents());
            }
            this.harEntry.getResponse().setBodySize(this.responseBodySize.get());
        }
        return super.serverToProxyResponse(httpObject);
    }

    public void serverToProxyResponseTimedOut() {
        HarResponse response = HarCaptureUtil.createHarResponseForFailure();
        this.harEntry.setResponse(response);
        response.setError(HarCaptureUtil.getResponseTimedOutErrorMessage());
        long timeoutTimestampNanos = System.nanoTime();
        if (this.sendStartedNanos > 0L && this.sendFinishedNanos == 0L) {
            this.harEntry.getTimings().setSend(timeoutTimestampNanos - this.sendStartedNanos, TimeUnit.NANOSECONDS);
        } else if (this.sendFinishedNanos > 0L && this.responseReceiveStartedNanos == 0L) {
            this.harEntry.getTimings().setWait(timeoutTimestampNanos - this.sendFinishedNanos, TimeUnit.NANOSECONDS);
        } else if (this.responseReceiveStartedNanos > 0L) {
            this.harEntry.getTimings().setReceive(timeoutTimestampNanos - this.responseReceiveStartedNanos, TimeUnit.NANOSECONDS);
        }
    }

    private HarRequest createHarRequestForHttpRequest(HttpRequest httpRequest) {
        String url = this.getFullUrl(httpRequest);
        return new HarRequest(httpRequest.getMethod().toString(), url, httpRequest.getProtocolVersion().text());
    }

    protected void captureQueryParameters(HttpRequest httpRequest) {
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(httpRequest.getUri(), StandardCharsets.UTF_8);
        try {
            for (Map.Entry entry : queryStringDecoder.parameters().entrySet()) {
                for (String value : (List)entry.getValue()) {
                    this.harEntry.getRequest().getQueryString().add(new HarNameValuePair((String)entry.getKey(), value));
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.harEntry.setComment("Unable to decode query parameters on URI: " + httpRequest.getUri());
            log.info("Unable to decode query parameters on URI: " + httpRequest.getUri(), (Throwable)e);
        }
    }

    protected void captureRequestHeaderSize(HttpRequest httpRequest) {
        String requestLine = String.valueOf(httpRequest.getMethod().toString()) + ' ' + httpRequest.getUri() + ' ' + httpRequest.getProtocolVersion().toString();
        long requestHeadersSize = requestLine.length() + 6;
        HttpHeaders headers = httpRequest.headers();
        this.harEntry.getRequest().setHeadersSize(requestHeadersSize += BrowserMobHttpUtil.getHeaderSize(headers));
    }

    protected void captureRequestCookies(HttpRequest httpRequest) {
        String cookieHeader = httpRequest.headers().get("Cookie");
        if (cookieHeader == null) {
            return;
        }
        Set cookies = ServerCookieDecoder.LAX.decode(cookieHeader);
        for (Cookie cookie : cookies) {
            HarCookie harCookie = new HarCookie();
            harCookie.setName(cookie.name());
            harCookie.setValue(cookie.value());
            this.harEntry.getRequest().getCookies().add(harCookie);
        }
    }

    protected void captureRequestHeaders(HttpRequest httpRequest) {
        HttpHeaders headers = httpRequest.headers();
        this.captureHeaders(headers);
    }

    protected void captureTrailingHeaders(LastHttpContent lastHttpContent) {
        HttpHeaders headers = lastHttpContent.trailingHeaders();
        this.captureHeaders(headers);
    }

    protected void captureHeaders(HttpHeaders headers) {
        for (Map.Entry header : headers.entries()) {
            this.harEntry.getRequest().getHeaders().add(new HarNameValuePair((String)header.getKey(), (String)header.getValue()));
        }
    }

    protected void captureRequestContent(HttpRequest httpRequest, byte[] fullMessage) {
        Charset charset;
        if (fullMessage.length == 0) {
            return;
        }
        String contentType = HttpHeaders.getHeader((HttpMessage)httpRequest, (String)"Content-Type");
        if (contentType == null) {
            log.warn("No content type specified in request to {}. Content will be treated as {}", (Object)httpRequest.getUri(), (Object)"application/octet-stream");
            contentType = "application/octet-stream";
        }
        HarPostData postData = new HarPostData();
        this.harEntry.getRequest().setPostData(postData);
        postData.setMimeType(contentType);
        boolean urlEncoded = contentType.startsWith("application/x-www-form-urlencoded");
        try {
            charset = BrowserMobHttpUtil.readCharsetInContentTypeHeader(contentType);
        }
        catch (UnsupportedCharsetException e) {
            log.warn("Found unsupported character set in Content-Type header '{}' in HTTP request to {}. Content will not be captured in HAR.", new Object[]{contentType, httpRequest.getUri(), e});
            return;
        }
        if (charset == null) {
            charset = BrowserMobHttpUtil.DEFAULT_HTTP_CHARSET;
            log.debug("No charset specified; using charset {} to decode contents to {}", (Object)charset, (Object)httpRequest.getUri());
        }
        if (urlEncoded) {
            String textContents = BrowserMobHttpUtil.getContentAsString(fullMessage, charset);
            QueryStringDecoder queryStringDecoder = new QueryStringDecoder(textContents, charset, false);
            ImmutableList.Builder paramBuilder = ImmutableList.builder();
            for (Map.Entry entry : queryStringDecoder.parameters().entrySet()) {
                for (String value : (List)entry.getValue()) {
                    paramBuilder.add((Object)new HarPostDataParam((String)entry.getKey(), value));
                }
            }
            this.harEntry.getRequest().getPostData().setParams((List<HarPostDataParam>)paramBuilder.build());
        } else {
            String postBody = BrowserMobHttpUtil.getContentAsString(fullMessage, charset);
            this.harEntry.getRequest().getPostData().setText(postBody);
        }
    }

    protected void captureResponseContent(HttpResponse httpResponse, byte[] fullMessage) {
        Charset charset;
        boolean forceBinary = false;
        String contentType = HttpHeaders.getHeader((HttpMessage)httpResponse, (String)"Content-Type");
        if (contentType == null) {
            log.warn("No content type specified in response from {}. Content will be treated as {}", (Object)this.originalRequest.getUri(), (Object)"application/octet-stream");
            contentType = "application/octet-stream";
        }
        if (this.responseCaptureFilter.isResponseCompressed() && !this.responseCaptureFilter.isDecompressionSuccessful()) {
            log.warn("Unable to decompress content with encoding: {}. Contents will be encoded as base64 binary data.", (Object)this.responseCaptureFilter.getContentEncoding());
            forceBinary = true;
        }
        try {
            charset = BrowserMobHttpUtil.readCharsetInContentTypeHeader(contentType);
        }
        catch (UnsupportedCharsetException e) {
            log.warn("Found unsupported character set in Content-Type header '{}' in HTTP response from {}. Content will not be captured in HAR.", new Object[]{contentType, this.originalRequest.getUri(), e});
            return;
        }
        if (charset == null) {
            charset = BrowserMobHttpUtil.DEFAULT_HTTP_CHARSET;
            log.debug("No charset specified; using charset {} to decode contents from {}", (Object)charset, (Object)this.originalRequest.getUri());
        }
        if (!forceBinary && BrowserMobHttpUtil.hasTextualContent(contentType)) {
            String text = BrowserMobHttpUtil.getContentAsString(fullMessage, charset);
            this.harEntry.getResponse().getContent().setText(text);
        } else if (this.dataToCapture.contains((Object)CaptureType.RESPONSE_BINARY_CONTENT)) {
            this.harEntry.getResponse().getContent().setText(BaseEncoding.base64().encode(fullMessage));
            this.harEntry.getResponse().getContent().setEncoding("base64");
        }
        this.harEntry.getResponse().getContent().setSize(fullMessage.length);
    }

    protected void captureResponse(HttpResponse httpResponse) {
        HarResponse response = new HarResponse(httpResponse.getStatus().code(), httpResponse.getStatus().reasonPhrase(), httpResponse.getProtocolVersion().text());
        this.harEntry.setResponse(response);
        this.captureResponseHeaderSize(httpResponse);
        this.captureResponseMimeType(httpResponse);
        if (this.dataToCapture.contains((Object)CaptureType.RESPONSE_COOKIES)) {
            this.captureResponseCookies(httpResponse);
        }
        if (this.dataToCapture.contains((Object)CaptureType.RESPONSE_HEADERS)) {
            this.captureResponseHeaders(httpResponse);
        }
        if (BrowserMobHttpUtil.isRedirect(httpResponse)) {
            this.captureRedirectUrl(httpResponse);
        }
    }

    protected void captureResponseMimeType(HttpResponse httpResponse) {
        String contentType = HttpHeaders.getHeader((HttpMessage)httpResponse, (String)"Content-Type");
        if (contentType != null) {
            this.harEntry.getResponse().getContent().setMimeType(contentType);
        }
    }

    protected void captureResponseCookies(HttpResponse httpResponse) {
        List setCookieHeaders = httpResponse.headers().getAll("Set-Cookie");
        if (setCookieHeaders == null) {
            return;
        }
        for (String setCookieHeader : setCookieHeaders) {
            Cookie cookie = ClientCookieDecoder.LAX.decode(setCookieHeader);
            if (cookie == null) {
                return;
            }
            HarCookie harCookie = new HarCookie();
            harCookie.setName(cookie.name());
            harCookie.setValue(cookie.value());
            harCookie.setDomain(cookie.domain());
            harCookie.setHttpOnly(cookie.isHttpOnly());
            harCookie.setPath(cookie.path());
            harCookie.setSecure(cookie.isSecure());
            if (cookie.maxAge() > 0L) {
                Calendar expires = Calendar.getInstance();
                expires.set(14, 0);
                expires.setTimeInMillis(expires.getTimeInMillis() + TimeUnit.MILLISECONDS.convert(cookie.maxAge(), TimeUnit.SECONDS));
                harCookie.setExpires(expires.getTime());
            }
            this.harEntry.getResponse().getCookies().add(harCookie);
        }
    }

    protected void captureResponseHeaderSize(HttpResponse httpResponse) {
        String statusLine = String.valueOf(httpResponse.getProtocolVersion().toString()) + ' ' + httpResponse.getStatus().toString();
        long responseHeadersSize = statusLine.length() + 6;
        HttpHeaders headers = httpResponse.headers();
        this.harEntry.getResponse().setHeadersSize(responseHeadersSize += BrowserMobHttpUtil.getHeaderSize(headers));
    }

    protected void captureResponseHeaders(HttpResponse httpResponse) {
        HttpHeaders headers = httpResponse.headers();
        for (Map.Entry header : headers.entries()) {
            this.harEntry.getResponse().getHeaders().add(new HarNameValuePair((String)header.getKey(), (String)header.getValue()));
        }
    }

    protected void captureRedirectUrl(HttpResponse httpResponse) {
        String locationHeaderValue = HttpHeaders.getHeader((HttpMessage)httpResponse, (String)"Location");
        if (locationHeaderValue != null) {
            this.harEntry.getResponse().setRedirectURL(locationHeaderValue);
        }
    }

    protected void captureRequestSize(HttpContent httpContent) {
        ByteBuf bufferedContent = httpContent.content();
        int contentSize = bufferedContent.readableBytes();
        this.requestBodySize.addAndGet(contentSize);
    }

    protected void captureResponseSize(HttpContent httpContent) {
        ByteBuf bufferedContent = httpContent.content();
        int contentSize = bufferedContent.readableBytes();
        this.responseBodySize.addAndGet(contentSize);
    }

    protected void captureConnectTiming() {
        HttpConnectTiming httpConnectTiming = HttpConnectHarCaptureFilter.consumeConnectTimingForConnection(this.clientAddress);
        if (httpConnectTiming != null) {
            this.harEntry.getTimings().setSsl(httpConnectTiming.getSslHandshakeTimeNanos(), TimeUnit.NANOSECONDS);
            this.harEntry.getTimings().setConnect(httpConnectTiming.getConnectTimeNanos(), TimeUnit.NANOSECONDS);
            this.harEntry.getTimings().setBlocked(httpConnectTiming.getBlockedTimeNanos(), TimeUnit.NANOSECONDS);
            this.harEntry.getTimings().setDns(httpConnectTiming.getDnsTimeNanos(), TimeUnit.NANOSECONDS);
        }
    }

    protected void populateAddressFromCache(HttpRequest httpRequest) {
        String serverHost = this.getHost(httpRequest);
        if (serverHost != null && !serverHost.isEmpty()) {
            String resolvedAddress = ResolvedHostnameCacheFilter.getPreviouslyResolvedAddressForHost(serverHost);
            if (resolvedAddress != null) {
                this.harEntry.setServerIPAddress(resolvedAddress);
            } else {
                log.trace("Unable to find cached IP address for host: {}. IP address in HAR entry will be blank.", (Object)serverHost);
            }
        } else {
            log.warn("Unable to identify host from request uri: {}", (Object)httpRequest.getUri());
        }
    }

    public InetSocketAddress proxyToServerResolutionStarted(String resolvingServerHostAndPort) {
        this.dnsResolutionStartedNanos = System.nanoTime();
        if (this.connectionQueuedNanos > 0L) {
            this.harEntry.getTimings().setBlocked(this.dnsResolutionStartedNanos - this.connectionQueuedNanos, TimeUnit.NANOSECONDS);
        } else {
            this.harEntry.getTimings().setBlocked(0L, TimeUnit.NANOSECONDS);
        }
        return null;
    }

    public void proxyToServerResolutionFailed(String hostAndPort) {
        HarResponse response = HarCaptureUtil.createHarResponseForFailure();
        this.harEntry.setResponse(response);
        response.setError(HarCaptureUtil.getResolutionFailedErrorMessage(hostAndPort));
        if (this.dnsResolutionStartedNanos > 0L) {
            this.harEntry.getTimings().setDns(System.nanoTime() - this.dnsResolutionStartedNanos, TimeUnit.NANOSECONDS);
        }
    }

    public void proxyToServerResolutionSucceeded(String serverHostAndPort, InetSocketAddress resolvedRemoteAddress) {
        long dnsResolutionFinishedNanos = System.nanoTime();
        if (this.dnsResolutionStartedNanos > 0L) {
            this.harEntry.getTimings().setDns(dnsResolutionFinishedNanos - this.dnsResolutionStartedNanos, TimeUnit.NANOSECONDS);
        } else {
            this.harEntry.getTimings().setDns(0L, TimeUnit.NANOSECONDS);
        }
        InetAddress resolvedAddress = resolvedRemoteAddress.getAddress();
        if (resolvedAddress != null) {
            this.addressResolved = true;
            this.harEntry.setServerIPAddress(resolvedAddress.getHostAddress());
        }
    }

    public void proxyToServerConnectionQueued() {
        this.connectionQueuedNanos = System.nanoTime();
    }

    public void proxyToServerConnectionStarted() {
        this.connectionStartedNanos = System.nanoTime();
    }

    public void proxyToServerConnectionFailed() {
        HarResponse response = HarCaptureUtil.createHarResponseForFailure();
        this.harEntry.setResponse(response);
        response.setError(HarCaptureUtil.getConnectionFailedErrorMessage());
        if (this.connectionStartedNanos > 0L) {
            this.harEntry.getTimings().setConnect(System.nanoTime() - this.connectionStartedNanos, TimeUnit.NANOSECONDS);
        }
    }

    public void proxyToServerConnectionSucceeded(ChannelHandlerContext serverCtx) {
        long connectionSucceededTimeNanos = System.nanoTime();
        if (this.connectionStartedNanos > 0L) {
            this.harEntry.getTimings().setConnect(connectionSucceededTimeNanos - this.connectionStartedNanos, TimeUnit.NANOSECONDS);
        } else {
            this.harEntry.getTimings().setConnect(0L, TimeUnit.NANOSECONDS);
        }
    }

    public void proxyToServerRequestSending() {
        this.sendStartedNanos = System.nanoTime();
        if (!this.addressResolved) {
            this.populateAddressFromCache(this.capturedOriginalRequest);
        }
    }

    public void proxyToServerRequestSent() {
        this.sendFinishedNanos = System.nanoTime();
        if (this.sendStartedNanos > 0L) {
            this.harEntry.getTimings().setSend(this.sendFinishedNanos - this.sendStartedNanos, TimeUnit.NANOSECONDS);
        } else {
            this.harEntry.getTimings().setSend(0L, TimeUnit.NANOSECONDS);
        }
    }

    public void serverToProxyResponseReceiving() {
        this.responseReceiveStartedNanos = System.nanoTime();
        if (this.sendFinishedNanos > 0L && this.sendFinishedNanos < this.responseReceiveStartedNanos) {
            this.harEntry.getTimings().setWait(this.responseReceiveStartedNanos - this.sendFinishedNanos, TimeUnit.NANOSECONDS);
        } else {
            this.harEntry.getTimings().setWait(0L, TimeUnit.NANOSECONDS);
        }
    }

    public void serverToProxyResponseReceived() {
        long responseReceivedNanos = System.nanoTime();
        if (this.responseReceiveStartedNanos > 0L) {
            this.harEntry.getTimings().setReceive(responseReceivedNanos - this.responseReceiveStartedNanos, TimeUnit.NANOSECONDS);
        } else {
            this.harEntry.getTimings().setReceive(0L, TimeUnit.NANOSECONDS);
        }
    }
}

