/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.base.util;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.springframework.context.i18n.LocaleContextHolder;

public class BundleUtil {
    public static String getLocaleString(String key, String resources) {
        Locale locale = LocaleContextHolder.getLocale();
        return ResourceBundle.getBundle(resources, locale).getString(key);
    }

    public static String getResString(String key) {
        return BundleUtil.getLocaleString(key, "net.mingsoft.base.resources.resources");
    }

    @Deprecated
    public static String getResString(String key, ResourceBundle rb) {
        try {
            return rb.getString(key);
        }
        catch (MissingResourceException var4) {
            return BundleUtil.getLocaleString(key, "net.mingsoft.base.resources.resources");
        }
    }

    @Deprecated
    public static String getResString(String key, String ... fullStrs) {
        String temp = BundleUtil.getResString(key);
        for (int i = 0; i < fullStrs.length; ++i) {
            temp = temp.replace("{" + i + "}", fullStrs[i]);
        }
        return temp;
    }

    @Deprecated
    public static String getResString(String key, ResourceBundle rb, String ... fullStrs) {
        String temp = "";
        try {
            temp = rb.getString(key);
        }
        catch (MissingResourceException e) {
            temp = BundleUtil.getResString(key);
        }
        for (int i = 0; i < fullStrs.length; ++i) {
            temp = temp.replace("{" + i + "}", fullStrs[i]);
        }
        return temp;
    }

    public static String getLocalString(String key, String ... fullStrs) {
        String temp = BundleUtil.getResString(key);
        for (int i = 0; i < fullStrs.length; ++i) {
            temp = temp.replace("{" + i + "}", fullStrs[i]);
        }
        return temp;
    }

    public static String getString(String resources, String key, String ... fullStrs) {
        Locale locale = LocaleContextHolder.getLocale();
        String temp = "";
        try {
            temp = ResourceBundle.getBundle(resources, locale).getString(key);
        }
        catch (MissingResourceException e) {
            temp = BundleUtil.getResString(key);
        }
        for (int i = 0; i < fullStrs.length; ++i) {
            temp = temp.replace("{" + i + "}", fullStrs[i]);
        }
        return temp;
    }
}

