/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.base.biz.impl;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.mingsoft.base.biz.IBaseBiz;
import net.mingsoft.base.biz.SqlQueryWrapper;
import net.mingsoft.base.dao.IBaseDao;
import net.mingsoft.base.entity.BaseEntity;
import net.mingsoft.base.exception.BusinessException;
import net.mingsoft.base.util.SqlInjectionUtil;
import net.mingsoft.base.util.SqlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.lang.Nullable;

public abstract class BaseBizImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<M, T>
implements IBaseBiz<T> {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Override
    public int update(String prepareSql, Object ... params) {
        this.LOG.debug("update sql:{}", (Object)SqlUtil.parseSql(prepareSql, params));
        int update = this.jdbcTemplate.update(prepareSql, params);
        this.LOG.debug("updates: {}", (Object)update);
        return update;
    }

    @Override
    public List<Map<String, Object>> queryForList(@Nullable SqlQueryWrapper sqlQueryWrapper) {
        return this.queryForList(sqlQueryWrapper.getQuerySql(), sqlQueryWrapper.getParams());
    }

    @Override
    public SqlQueryWrapper.EUListBean queryForListPage(@Nullable SqlQueryWrapper sqlQueryWrapper) {
        List<Map<String, Object>> list = this.queryForList(sqlQueryWrapper.getQuerySql(), sqlQueryWrapper.getParams());
        return new SqlQueryWrapper.EUListBean(list, sqlQueryWrapper.getTotal());
    }

    @Override
    public List<Map<String, Object>> queryForList(String prepareSql, Object ... params) {
        this.LOG.debug("queryForList sql:{}", (Object)SqlUtil.parseSql(prepareSql, params));
        return this.jdbcTemplate.queryForList(prepareSql, params);
    }

    @Override
    public int insert(String tableName, Map fields) {
        if (MapUtil.isEmpty((Map)fields)) {
            throw new BusinessException("insert\u7684\u5b57\u6bb5\u5217\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String fieldNames = String.join((CharSequence)", ", fields.keySet());
        String placeholders = String.join((CharSequence)", ", Collections.nCopies(fields.size(), "?"));
        String sql = StrUtil.format((CharSequence)"INSERT INTO {} ({}) VALUES ({})", (Object[])new Object[]{tableName, fieldNames, placeholders});
        Object[] params = fields.values().toArray();
        this.LOG.debug("insert sql: {}", (Object)SqlUtil.parseSql(sql, params));
        return this.jdbcTemplate.update(sql, params);
    }

    @Override
    public int update(String tableName, Map fields, Map whereFields) {
        if (MapUtil.isEmpty((Map)fields)) {
            throw new BusinessException("update\u7684\u5b57\u6bb5\u5217\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String prepareSql = StrUtil.format((CharSequence)"UPDATE {} ", (Object[])new Object[]{tableName});
        ArrayList params = new ArrayList();
        Object fieldNames = String.join((CharSequence)" = ? , ", fields.keySet());
        fieldNames = (String)fieldNames + " = ?";
        prepareSql = StrUtil.format((CharSequence)(prepareSql + "SET {} "), (Object[])new Object[]{fieldNames});
        params.addAll(fields.values());
        if (MapUtil.isNotEmpty((Map)whereFields)) {
            Object whereFieldNames = String.join((CharSequence)" = ? AND ", whereFields.keySet());
            whereFieldNames = (String)whereFieldNames + " = ?";
            prepareSql = StrUtil.format((CharSequence)(prepareSql + " WHERE {} "), (Object[])new Object[]{whereFieldNames});
            params.addAll(whereFields.values());
        }
        this.LOG.debug("update sql: {}", (Object)SqlUtil.parseSql(prepareSql, params.toArray()));
        return this.jdbcTemplate.update(prepareSql, params.toArray());
    }

    @Override
    public int delete(String tableName, Map whereFields) {
        String prepareSql = StrUtil.format((CharSequence)"DELETE FROM {}  ", (Object[])new Object[]{tableName});
        ArrayList params = new ArrayList();
        if (MapUtil.isNotEmpty((Map)whereFields)) {
            Object whereFieldNames = String.join((CharSequence)" = ? AND ", whereFields.keySet());
            whereFieldNames = (String)whereFieldNames + " = ?";
            prepareSql = StrUtil.format((CharSequence)(prepareSql + " WHERE {} "), (Object[])new Object[]{whereFieldNames});
            params.addAll(whereFields.values());
        }
        this.LOG.debug("delete sql: {}", (Object)SqlUtil.parseSql(prepareSql, params.toArray()));
        return this.jdbcTemplate.update(prepareSql, params.toArray());
    }

    @Override
    public void execute(String sql) {
        this.LOG.debug("execute sql:{}", (Object)sql);
        this.jdbcTemplate.execute(sql);
    }

    @Override
    public void delete(int[] ids) {
        this.getDao().delete(ids);
    }

    @Override
    public void delete(String[] ids) {
        this.getDao().delete(ids);
    }

    @Override
    public void updateCache() {
        this.getDao().updateCache();
    }

    @Override
    public List<T> query(BaseEntity entity) {
        return this.getDao().query(entity);
    }

    protected abstract IBaseDao<T> getDao();

    public T getOne(Wrapper<T> queryWrapper, boolean throwEx) {
        return (T)super.getOne(queryWrapper, throwEx);
    }

    @Override
    public Object excuteSql(String sql) {
        return this.getDao().excuteSql(sql);
    }

    @Override
    public void saveBatch(List list) {
        this.getDao().saveBatch(list);
    }

    @Override
    public int saveEntity(BaseEntity entity) {
        return this.getDao().saveEntity(entity);
    }

    @Override
    public void deleteEntity(BaseEntity entity) {
        this.getDao().deleteByEntity(entity);
    }

    @Override
    public void deleteEntity(int id) {
        this.getDao().deleteEntity(id);
    }

    @Override
    public void updateEntity(BaseEntity entity) {
        this.getDao().updateEntity(entity);
    }

    @Override
    public List<T> queryAll() {
        return this.getDao().queryAll();
    }

    @Override
    @Deprecated
    public int queryCount() {
        return this.getDao().queryCount();
    }

    @Override
    public T getEntity(BaseEntity entity) {
        return this.getDao().getByEntity(entity);
    }

    @Override
    public BaseEntity getEntity(int id) {
        return this.getDao().getEntity(id);
    }

    @Override
    public BaseEntity getEntity(String id) {
        return this.getDao().getEntity(id);
    }

    @Override
    public void createTable(String table, Map fileds) {
        SqlInjectionUtil.filterContent(table);
        this.getDao().createTable(table, fileds);
    }

    @Override
    public void dropTable(String table) {
        SqlInjectionUtil.filterContent(table);
        this.getDao().dropTable(table);
    }

    @Override
    public void alterTable(String table, Map fileds, String type) {
        SqlInjectionUtil.filterContent(table);
        this.getDao().alterTable(table, fileds, type);
    }

    @Override
    public void insertBySQL(String table, Map fields) {
        SqlInjectionUtil.filterContent(table);
        this.getDao().insertBySQL(table, fields);
    }

    @Override
    public void deleteBySQL(String table, Map wheres) {
        SqlInjectionUtil.filterContent(table);
        this.getDao().deleteBySQL(table, wheres);
    }

    @Override
    public void updateBySQL(String table, Map fields, Map wheres) {
        SqlInjectionUtil.filterContent(table);
        this.getDao().updateBySQL(table, fields, wheres);
    }
}

