/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.base.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.ParenthesedExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;

public class SqlUtil {
    private static final char MARK = '?';
    private static final Set<String> NOT_NEED_BRACKETS;
    private static final Set<String> NEED_BRACKETS;

    @Deprecated
    public static StringBuilder parseSql(String sql, Queue<Map.Entry<String, Object>> params) {
        StringBuilder sb = new StringBuilder(sql);
        for (int i = 0; i < sb.length(); ++i) {
            Map.Entry<String, Object> param;
            if (sb.charAt(i) != '?' || Objects.isNull(param = params.poll())) continue;
            sb.deleteCharAt(i);
            if (NOT_NEED_BRACKETS.contains(param.getKey())) {
                sb.insert(i, param.getValue());
                continue;
            }
            sb.insert(i, String.format("'%s'", param.getValue()));
        }
        return sb;
    }

    public static StringBuilder parseSql(String sql, Object ... params) {
        StringBuilder sb = new StringBuilder(sql);
        if (Objects.isNull(params)) {
            return sb;
        }
        LinkedList queue = new LinkedList();
        Collections.addAll(queue, params);
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != '?') continue;
            Object param = queue.poll();
            sb.deleteCharAt(i);
            if (Objects.isNull(param)) {
                sb.insert(i, "null");
                continue;
            }
            if (NEED_BRACKETS.contains(param.getClass().getSimpleName())) {
                sb.insert(i, String.format("'%s'", param));
                continue;
            }
            sb.insert(i, param);
        }
        return sb;
    }

    public static String addCondition(String sql, String condition) {
        try {
            FromItem fromItem;
            Function function;
            Expression expression;
            String formatSql = sql.replaceAll("\\n{2,}", "\n");
            Statement statement = CCJSqlParserUtil.parse((String)formatSql);
            Expression dataScopeExpression = CCJSqlParserUtil.parseExpression((String)condition);
            ParenthesedExpressionList expressions = new ParenthesedExpressionList(List.of(dataScopeExpression));
            Select select = (Select)statement;
            PlainSelect plainSelect = select.getPlainSelect();
            PlainSelect targetSelect = select.getPlainSelect();
            boolean isPageHelperCountQuery = false;
            List selectItems = plainSelect.getSelectItems();
            if (selectItems.size() == 1 && (expression = ((SelectItem)selectItems.get(0)).getExpression()) instanceof Function && "COUNT".equalsIgnoreCase((function = (Function)expression).getName())) {
                isPageHelperCountQuery = true;
            }
            if (isPageHelperCountQuery && (fromItem = plainSelect.getFromItem()) instanceof ParenthesedSelect) {
                ParenthesedSelect parenthesedSelect = (ParenthesedSelect)fromItem;
                targetSelect = parenthesedSelect.getSelect().getPlainSelect();
            }
            if (targetSelect.getWhere() != null) {
                targetSelect.setWhere((Expression)new AndExpression(targetSelect.getWhere(), (Expression)expressions));
            } else {
                targetSelect.setWhere((Expression)expressions);
            }
            return statement.toString();
        }
        catch (JSQLParserException e) {
            e.printStackTrace();
            return sql;
        }
    }

    static {
        HashSet<String> types = new HashSet<String>(1);
        types.add("number");
        NOT_NEED_BRACKETS = Collections.unmodifiableSet(types);
        types = new HashSet(9);
        types.add("String");
        types.add("Date");
        types.add("Time");
        types.add("LocalDate");
        types.add("LocalTime");
        types.add("LocalDateTime");
        types.add("BigDecimal");
        types.add("Timestamp");
        types.add("DateTime");
        NEED_BRACKETS = Collections.unmodifiableSet(types);
    }
}

