/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.resolver;

import cn.hutool.core.util.ObjectUtil;
import java.io.IOException;
import net.mingsoft.base.resolver.MultipartResolver;
import net.mingsoft.basic.config.MultipartProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties(value={MultipartProperties.class})
public class CustomMultipartResolver
extends MultipartResolver {
    public CustomMultipartResolver(MultipartProperties multipartProperties) throws IOException {
        if (ObjectUtil.isNotNull((Object)multipartProperties.getUploadTempDir())) {
            this.setUploadTempDir(multipartProperties.getUploadTempDir());
        }
        this.setDefaultEncoding(multipartProperties.getDefaultEncoding());
        this.setMaxUploadSize(multipartProperties.getMaxFileSize());
        this.setMaxUploadSizePerFile(multipartProperties.getMaxRequestSize());
        this.setMaxInMemorySize(multipartProperties.getMaxInMemorySize());
        this.setResolveLazily(multipartProperties.isResolveLazily());
        this.setExcludeUrls("jsp/editor.do");
    }
}

