/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.config;

import jakarta.annotation.Resource;
import jakarta.servlet.MultipartConfigElement;
import net.mingsoft.config.MSProperties;
import org.springframework.boot.web.servlet.MultipartConfigFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.unit.DataSize;

@Configuration
public class MultipartConfig {
    @Resource
    private MSProperties msProperties;

    @Bean
    public MultipartConfigElement multipartConfigElement() {
        MultipartConfigFactory factory = new MultipartConfigFactory();
        long maxFileSize = this.msProperties.getUpload().multipart.getMaxFileSize();
        long maxRequestSize = this.msProperties.getUpload().multipart.getMaxRequestSize();
        factory.setMaxFileSize(DataSize.ofKilobytes((long)maxFileSize));
        factory.setMaxRequestSize(DataSize.ofKilobytes((long)maxRequestSize));
        factory.setLocation(this.msProperties.getUpload().getMultipart().getUploadTempDir());
        return factory.createMultipartConfig();
    }
}

