/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda.maven;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

abstract class ProcessClassesMojo
extends AbstractMojo {
    private static final Map<String, Integer> targetBytecodeVersions = ImmutableMap.of((Object)"1.5", (Object)49, (Object)"1.6", (Object)50, (Object)"1.7", (Object)51, (Object)"1.8", (Object)52);
    @Component
    ToolchainManager toolchainManager;
    @Component
    private BuildPluginManager pluginManager;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="java8home", required=false)
    public File java8home;
    @Parameter(defaultValue="1.7", property="retrolambdaTarget", required=true)
    public String target;
    @Parameter(defaultValue="false", property="retrolambdaDefaultMethods", required=true)
    public boolean defaultMethods;
    @Parameter(defaultValue="false", property="retrolambdaJavacHacks", required=true)
    public boolean javacHacks;
    @Parameter(defaultValue="false", property="retrolambdaQuiet", required=true)
    public boolean quiet;
    @Parameter(defaultValue="false")
    public boolean fork;

    ProcessClassesMojo() {
    }

    protected abstract File getInputDir();

    protected abstract File getOutputDir();

    protected abstract List<String> getClasspathElements() throws DependencyResolutionRequiredException;

    public void execute() throws MojoExecutionException {
        this.validateTarget();
        this.validateFork();
        Properties config = new Properties();
        config.setProperty("retrolambda.bytecodeVersion", "" + targetBytecodeVersions.get(this.target));
        config.setProperty("retrolambda.defaultMethods", "" + this.defaultMethods);
        config.setProperty("retrolambda.quiet", "" + this.quiet);
        config.setProperty("retrolambda.inputDir", this.getInputDir().getAbsolutePath());
        config.setProperty("retrolambda.outputDir", this.getOutputDir().getAbsolutePath());
        config.setProperty("retrolambda.classpath", this.getClasspath());
        config.setProperty("retrolambda.javacHacks", "" + this.javacHacks);
        if (this.fork) {
            this.processClassesInForkedProcess(config);
        } else {
            this.processClassesInCurrentProcess(config);
        }
    }

    private void validateTarget() throws MojoExecutionException {
        if (!targetBytecodeVersions.containsKey(this.target)) {
            String possibleValues = Joiner.on((String)", ").join(new TreeSet<String>(targetBytecodeVersions.keySet()));
            throw new MojoExecutionException("Unrecognized target '" + this.target + "'. Possible values are " + possibleValues);
        }
    }

    private void validateFork() {
        if (!this.fork && !SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8)) {
            this.getLog().warn((CharSequence)"Maven is not running under Java 8 - forced to fork the process");
            this.fork = true;
        }
    }

    private void processClassesInCurrentProcess(Properties config) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Processing classes with Retrolambda");
        try {
            Class.forName("net.orfjackal.retrolambda.Retrolambda").getMethod("run", Properties.class).invoke(null, config);
        }
        catch (Throwable t) {
            throw new MojoExecutionException("Failed to run Retrolambda", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClassesInForkedProcess(Properties config) throws MojoExecutionException {
        String version = ProcessClassesMojo.getRetrolambdaVersion();
        this.getLog().info((CharSequence)("Retrieving Retrolambda " + version));
        this.retrieveRetrolambdaJar(version);
        this.getLog().info((CharSequence)"Processing classes with Retrolambda");
        String retrolambdaJar = this.getRetrolambdaJarPath();
        File classpathFile = this.getClasspathFile();
        try {
            ArrayList<MojoExecutor.Element> args = new ArrayList<MojoExecutor.Element>();
            for (Object key : config.keySet()) {
                Object value = config.get(key);
                if (key.equals("retrolambda.classpath")) {
                    key = "retrolambda.classpathFile";
                    value = classpathFile.getAbsolutePath();
                }
                args.add(MojoExecutor.element((String)"arg", (MojoExecutor.Attribute)MojoExecutor.attribute((String)"value", (String)("-D" + key + "=" + value)), (MojoExecutor.Element[])new MojoExecutor.Element[0]));
            }
            args.add(MojoExecutor.element((String)"arg", (MojoExecutor.Attribute)MojoExecutor.attribute((String)"value", (String)("-javaagent:" + retrolambdaJar)), (MojoExecutor.Element[])new MojoExecutor.Element[0]));
            args.add(MojoExecutor.element((String)"arg", (MojoExecutor.Attribute)MojoExecutor.attribute((String)"value", (String)"-jar"), (MojoExecutor.Element[])new MojoExecutor.Element[0]));
            args.add(MojoExecutor.element((String)"arg", (MojoExecutor.Attribute)MojoExecutor.attribute((String)"value", (String)retrolambdaJar), (MojoExecutor.Element[])new MojoExecutor.Element[0]));
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-antrun-plugin"), (String)MojoExecutor.version((String)"1.7")), (String)MojoExecutor.goal((String)"run"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"target", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"exec", (MojoExecutor.Attributes)MojoExecutor.attributes((MojoExecutor.Attribute[])new MojoExecutor.Attribute[]{MojoExecutor.attribute((String)"executable", (String)this.getJavaCommand()), MojoExecutor.attribute((String)"failonerror", (String)"true")}), (MojoExecutor.Element[])args.toArray(new MojoExecutor.Element[0]))})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
        }
        finally {
            if (!classpathFile.delete()) {
                this.getLog().warn((CharSequence)("Unable to delete " + classpathFile));
            }
        }
    }

    private void retrieveRetrolambdaJar(String version) throws MojoExecutionException {
        MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-dependency-plugin"), (String)MojoExecutor.version((String)"2.8")), (String)MojoExecutor.goal((String)"copy"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"artifactItems", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"artifactItem", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)MojoExecutor.name((String)"groupId"), (String)"net.orfjackal.retrolambda"), MojoExecutor.element((String)MojoExecutor.name((String)"artifactId"), (String)"retrolambda"), MojoExecutor.element((String)MojoExecutor.name((String)"version"), (String)version), MojoExecutor.element((String)MojoExecutor.name((String)"overWrite"), (String)"true"), MojoExecutor.element((String)MojoExecutor.name((String)"outputDirectory"), (String)this.getRetrolambdaJarDir()), MojoExecutor.element((String)MojoExecutor.name((String)"destFileName"), (String)this.getRetrolambdaJarName())})})}), (MojoExecutor.ExecutionEnvironment)MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager));
    }

    String getJavaCommand() {
        String javaCommand = ProcessClassesMojo.getJavaCommand(new File(System.getProperty("java.home")));
        Toolchain tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        if (tc != null) {
            this.getLog().info((CharSequence)("Toolchain in retrolambda-maven-plugin: " + tc));
            javaCommand = tc.findTool("java");
        }
        if (this.java8home != null) {
            if (tc != null) {
                this.getLog().warn((CharSequence)("Toolchains are ignored, 'java8home' parameter is set to " + this.java8home));
            }
            javaCommand = ProcessClassesMojo.getJavaCommand(this.java8home);
        }
        return javaCommand;
    }

    private static String getJavaCommand(File javaHome) {
        return new File(javaHome, "bin/java").getPath();
    }

    private String getClasspath() {
        try {
            return Joiner.on((String)File.pathSeparator).join(this.getClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new RuntimeException(e);
        }
    }

    private File getClasspathFile() {
        try {
            String classpath = Joiner.on((String)"\n").join(this.getClasspathElements());
            File file = File.createTempFile("retrolambda", "classpath");
            file.deleteOnExit();
            Files.write((CharSequence)classpath, (File)file, (Charset)Charsets.UTF_8);
            return file;
        }
        catch (DependencyResolutionRequiredException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getRetrolambdaJarPath() {
        return this.getRetrolambdaJarDir() + "/" + this.getRetrolambdaJarName();
    }

    private String getRetrolambdaJarDir() {
        return this.project.getBuild().getDirectory() + "/retrolambda";
    }

    private String getRetrolambdaJarName() {
        return "retrolambda.jar";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRetrolambdaVersion() throws MojoExecutionException {
        String string;
        InputStream is = ProcessClassesMojo.class.getResourceAsStream("/META-INF/maven/net.orfjackal.retrolambda/retrolambda-maven-plugin/pom.properties");
        try {
            Properties p = new Properties();
            p.load(is);
            string = p.getProperty("version");
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to detect the Retrolambda version", (Exception)e);
            }
        }
        is.close();
        return string;
    }
}

