/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.GroupType;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.classdiagram.command.CommandCreateClassMultilines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.decoration.symbol.USymbols;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotag;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.url.UrlBuilder;
import net.sourceforge.plantuml.url.UrlMode;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandPackage
extends SingleLineCommand2<AbstractEntityDiagram> {
    public CommandPackage() {
        super(CommandPackage.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandPackage.class.getName(), RegexLeaf.start(), new RegexLeaf("TYPE", "(package)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("NAME", "([%g][^%g]+[%g]|[^#%s{}]*)"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("AS", "([%pLN_.]+)"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("TAGS1", Stereotag.pattern() + "?"), StereotypePattern.optional("STEREOTYPE"), new RegexLeaf("TAGS2", Stereotag.pattern() + "?"), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, RegexLeaf.spaceZeroOrMore(), CommandPackage.color().getRegex(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\{"), RegexLeaf.end());
    }

    @Override
    public boolean syntaxWithFinalBracket() {
        return true;
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractEntityDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
        Quark<Entity> quark;
        String display;
        String name = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("NAME", 0));
        if (arg.get("AS", 0) == null) {
            String idShort;
            if (name.length() == 0) {
                String idShort2 = "##" + diagram.getUniqueSequence("");
                Object display2 = null;
                return CommandExecutionResult.error("Error in name");
            }
            display = idShort = name;
        } else {
            display = name;
            String idShort = arg.get("AS", 0);
        }
        if (arg.get("AS", 0) == null) {
            quark = diagram.quarkInContext(false, diagram.cleanId(name));
            display = quark.getName();
        } else {
            quark = diagram.quarkInContext(false, diagram.cleanId(arg.get("AS", 0)));
            display = name;
        }
        String stereotype = arg.get("STEREOTYPE", 0);
        USymbol usymbol = USymbols.fromString(stereotype, diagram.getSkinParam().actorStyle(), diagram.getSkinParam().componentStyle(), diagram.getSkinParam().packageStyle());
        CommandExecutionResult status = diagram.gotoGroup(quark, Display.getWithNewlines(display), GroupType.PACKAGE, usymbol);
        if (!status.isOk()) {
            return status;
        }
        Entity p = diagram.getCurrentGroup();
        if (stereotype != null && usymbol == null) {
            p.setStereotype(Stereotype.build(stereotype));
        }
        CommandCreateClassMultilines.addTags(p, arg.getLazzy("TAGS", 0));
        String urlString = arg.get("URL", 0);
        if (urlString != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            p.addUrl(url);
        }
        Colors colors = CommandPackage.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        p.setColors(colors);
        return CommandExecutionResult.ok();
    }
}

