/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.dot;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.atmp.CucaDiagram;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.EntityPortion;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.asciiart.BasicCharArea;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.txt.UGraphicTxt;
import net.sourceforge.plantuml.klimt.geom.XCubicCurve2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.DotPath;
import net.sourceforge.plantuml.posimo.Block;
import net.sourceforge.plantuml.posimo.Cluster;
import net.sourceforge.plantuml.posimo.GraphvizSolverB;
import net.sourceforge.plantuml.posimo.Path;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.text.BackSlash;

public final class CucaDiagramTxtMaker {
    private final FileFormat fileFormat;
    private final UGraphicTxt globalUg = new UGraphicTxt();
    private final PortionShower portionShower;

    private static double getXPixelPerChar() {
        return 5.0;
    }

    private static double getYPixelPerChar() {
        return 10.0;
    }

    private boolean showMember(Entity entity) {
        boolean showMethods = this.portionShower.showPortion(EntityPortion.METHOD, entity);
        boolean showFields = this.portionShower.showPortion(EntityPortion.FIELD, entity);
        return showMethods || showFields;
    }

    public CucaDiagramTxtMaker(CucaDiagram diagram, FileFormat fileFormat) throws IOException {
        this.fileFormat = fileFormat;
        this.portionShower = diagram;
        Cluster root = new Cluster(null, 0.0, 0.0);
        int uid = 0;
        HashMap<Entity, Block> blocks = new HashMap<Entity, Block>();
        for (Entity ent : diagram.leafs()) {
            double width = (double)this.getWidth(ent) * CucaDiagramTxtMaker.getXPixelPerChar();
            double height = (double)this.getHeight(ent) * CucaDiagramTxtMaker.getYPixelPerChar();
            Block b = new Block(uid++, width, height, null);
            root.addBloc(b);
            blocks.put(ent, b);
        }
        GraphvizSolverB solver = new GraphvizSolverB();
        ArrayList<Path> paths = new ArrayList<Path>();
        for (Link link : diagram.getLinks()) {
            Block b1 = (Block)blocks.get(link.getEntity1());
            Block b2 = (Block)blocks.get(link.getEntity2());
            paths.add(new Path(b1, b2, null, link.getLength(), link.isInvis()));
        }
        solver.solve(root, paths);
        for (Path p : paths) {
            if (p.isInvis()) continue;
            this.drawDotPath(p.getDotPath(), this.globalUg.getCharArea(), CucaDiagramTxtMaker.getXPixelPerChar(), CucaDiagramTxtMaker.getYPixelPerChar());
        }
        for (Entity ent : diagram.leafs()) {
            Block b = (Block)blocks.get(ent);
            XPoint2D p = b.getPosition();
            this.printClass(ent, (UGraphicTxt)this.globalUg.apply(new UTranslate(p.getX() / CucaDiagramTxtMaker.getXPixelPerChar(), p.getY() / CucaDiagramTxtMaker.getYPixelPerChar())));
        }
    }

    private void drawDotPath(DotPath dotPath, BasicCharArea area, double pixelXPerChar, double pixelYPerChar) {
        for (XCubicCurve2D bez : dotPath.getBeziers()) {
            if (bez.x1 == bez.x2) {
                area.drawVLine('|', (int)(bez.x1 / pixelXPerChar), (int)(bez.y1 / pixelYPerChar), (int)(bez.y2 / pixelYPerChar));
                continue;
            }
            if (bez.y1 != bez.y2) continue;
            area.drawHLine('-', (int)(bez.y1 / pixelYPerChar), (int)(bez.x1 / pixelXPerChar), (int)(bez.x2 / pixelXPerChar));
        }
    }

    private void printClass(Entity ent, UGraphicTxt ug) {
        if (this.fileFormat == FileFormat.UTXT) {
            this.drawClassUnicode(ent, ug);
        } else {
            this.drawClassSimple(ent, ug);
        }
    }

    private void drawClassSimple(Entity ent, UGraphicTxt ug) {
        int w = this.getWidth(ent);
        int h = this.getHeight(ent);
        ug.getCharArea().drawBoxSimple(0, 0, w, h);
        ug.getCharArea().drawStringsLRSimple(ent.getDisplay().asList(), 1, 1);
        if (this.showMember(ent)) {
            int y = 2;
            ug.getCharArea().drawHLine('-', y, 1, w - 1);
            ++y;
            for (CharSequence att : ent.getBodier().getRawBody()) {
                List<String> disp = BackSlash.getWithNewlines(att.toString());
                ug.getCharArea().drawStringsLRSimple(disp, 1, y);
                y += StringUtils.getHeight(disp);
            }
        }
    }

    private void drawClassUnicode(Entity ent, UGraphicTxt ug) {
        int w = this.getWidth(ent);
        int h = this.getHeight(ent);
        ug.getCharArea().drawBoxSimpleUnicode(0, 0, w, h);
        ug.getCharArea().drawStringsLRUnicode(ent.getDisplay().asList(), 1, 1);
        if (this.showMember(ent)) {
            int y = 2;
            ug.getCharArea().drawHLine('\u2500', y, 1, w - 1);
            ug.getCharArea().drawChar('\u251c', 0, y);
            ug.getCharArea().drawChar('\u2524', w - 1, y);
            ++y;
            for (CharSequence att : ent.getBodier().getRawBody()) {
                List<String> disp = BackSlash.getWithNewlines(att.toString());
                ug.getCharArea().drawStringsLRUnicode(disp, 1, y);
                y += StringUtils.getHeight(disp);
            }
        }
    }

    public List<SFile> createFiles(SFile suggestedFile) throws IOException {
        if (this.fileFormat == FileFormat.UTXT) {
            this.globalUg.getCharArea().print(suggestedFile.createPrintStream(StandardCharsets.UTF_8));
        } else {
            this.globalUg.getCharArea().print(suggestedFile.createPrintStream());
        }
        return Collections.singletonList(suggestedFile);
    }

    private int getHeight(Entity entity) {
        int result = StringUtils.getHeight(entity.getDisplay());
        if (this.showMember(entity)) {
            for (CharSequence att : entity.getBodier().getRawBody()) {
                result += StringUtils.getHeight(Display.getWithNewlines(att.toString()));
            }
        }
        return result + 3;
    }

    private int getWidth(Entity entity) {
        int result = StringUtils.getWcWidth(entity.getDisplay());
        if (this.showMember(entity)) {
            for (CharSequence att : entity.getBodier().getRawBody()) {
                int w = StringUtils.getWcWidth(Display.getWithNewlines(att.toString()));
                if (w <= result) continue;
                result = w;
            }
        }
        return result + 2;
    }

    public void createFiles(OutputStream os, int index) {
        this.globalUg.getCharArea().print(SecurityUtils.createPrintStream(os));
    }
}

