/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ebnf;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.ebnf.CornerCurved;
import net.sourceforge.plantuml.ebnf.ETile;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;

public class ETileAlternation
extends ETile {
    private final List<ETile> tiles = new ArrayList<ETile>();
    private final double marginx = 12.0;
    private boolean inZeroOrMore;

    @Override
    public void push(ETile tile) {
        this.tiles.add(0, tile);
    }

    @Override
    public double getH1(StringBounder stringBounder) {
        return this.tiles.get(0).getH1(stringBounder);
    }

    @Override
    public double getH2(StringBounder stringBounder) {
        double height = this.tiles.get(0).getH2(stringBounder);
        for (int i = 1; i < this.tiles.size(); ++i) {
            ETile tile = this.tiles.get(i);
            height += tile.getH1(stringBounder);
            height += tile.getH2(stringBounder);
            height += 10.0;
        }
        return height;
    }

    @Override
    public double getWidth(StringBounder stringBounder) {
        double width = 0.0;
        for (ETile tile : this.tiles) {
            XDimension2D dim = tile.calculateDimension(stringBounder);
            width = Math.max(width, dim.getWidth());
        }
        return width += 48.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        double y = 0.0;
        double lastLinePos = 0.0;
        double a = 0.0;
        double b = 12.0;
        double c = 24.0;
        XDimension2D fullDim = this.calculateDimension(stringBounder);
        double r = fullDim.getWidth();
        double q = r - 12.0;
        double p = q - 12.0;
        double linePos = this.getH1(stringBounder);
        if (this.inZeroOrMore) {
            for (int i = 0; i < this.tiles.size(); ++i) {
                ETile tile = this.tiles.get(i);
                XDimension2D dim = tile.calculateDimension(stringBounder);
                lastLinePos = y + tile.getH1(stringBounder);
                tile.drawU(ug.apply(new UTranslate(24.0, y)));
                CornerCurved.createSW(12.0).drawU(ug.apply(new UTranslate(12.0, lastLinePos)));
                this.drawHlineDirected(ug, lastLinePos, 24.0 + dim.getWidth(), p, 0.3, 25.0);
                CornerCurved.createSE(12.0).drawU(ug.apply(new UTranslate(q, lastLinePos)));
                y += dim.getHeight() + 10.0;
            }
            this.drawVline(ug, 12.0, 0.0, lastLinePos - 12.0);
            this.drawVline(ug, q, 0.0, lastLinePos - 12.0);
        } else {
            for (int i = 0; i < this.tiles.size(); ++i) {
                ETile tile = this.tiles.get(i);
                XDimension2D dim = tile.calculateDimension(stringBounder);
                lastLinePos = y + tile.getH1(stringBounder);
                tile.drawU(ug.apply(new UTranslate(24.0, y)));
                if (i == 0) {
                    this.drawHline(ug, lastLinePos, 0.0, 24.0);
                    this.drawHline(ug, lastLinePos, 24.0 + dim.getWidth(), r);
                } else if (i > 0 && i < this.tiles.size() - 1) {
                    CornerCurved.createSW(12.0).drawU(ug.apply(new UTranslate(12.0, lastLinePos)));
                    this.drawHlineDirected(ug, lastLinePos, 24.0 + dim.getWidth(), p, 0.5, 25.0);
                    CornerCurved.createSE(12.0).drawU(ug.apply(new UTranslate(q, lastLinePos)));
                } else if (i == this.tiles.size() - 1) {
                    this.drawHlineDirected(ug, lastLinePos, 24.0 + dim.getWidth(), p, 0.5, 25.0);
                }
                y += dim.getHeight() + 10.0;
            }
            double height42 = lastLinePos - linePos;
            UGraphic ug_b = ug.apply(new UTranslate(12.0, linePos));
            UGraphic ug_q = ug.apply(new UTranslate(q, linePos));
            CornerCurved.createSW(12.0).drawU(ug_b.apply(UTranslate.dy(height42)));
            this.drawVline(ug_b, 0.0, 12.0, height42 - 12.0);
            CornerCurved.createNE(12.0).drawU(ug_b);
            CornerCurved.createSE(12.0).drawU(ug_q.apply(UTranslate.dy(height42)));
            this.drawVline(ug_q, 0.0, 12.0, height42 - 12.0);
            CornerCurved.createNW(12.0).drawU(ug_q);
        }
    }

    public void setInZeroOrMore(boolean inZeroOrMore) {
        this.inZeroOrMore = true;
    }
}

