/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ebnf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FloatingNote;
import net.sourceforge.plantuml.ebnf.ETile;
import net.sourceforge.plantuml.ebnf.ETileEmpty;
import net.sourceforge.plantuml.ebnf.ETileWithCircles;
import net.sourceforge.plantuml.ebnf.EbnfEngine;
import net.sourceforge.plantuml.ebnf.ShuntingYard;
import net.sourceforge.plantuml.ebnf.Symbol;
import net.sourceforge.plantuml.ebnf.TextBlockable;
import net.sourceforge.plantuml.ebnf.TitleBox;
import net.sourceforge.plantuml.ebnf.Token;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.utils.CharInspector;

public class EbnfExpression
implements TextBlockable {
    private final List<Token> tokens = new ArrayList<Token>();
    private final boolean isCompact;
    private final String commentAbove;
    private final String commentBelow;

    public static EbnfExpression create(CharInspector it, boolean isCompact, String commentAbove, String commentBelow) {
        return new EbnfExpression(it, isCompact, commentAbove, commentBelow);
    }

    private EbnfExpression(CharInspector it, boolean isCompact, String commentAbove, String commentBelow) {
        this.isCompact = isCompact;
        this.commentAbove = commentAbove;
        this.commentBelow = commentBelow;
        while (true) {
            char ch;
            if (!Character.isWhitespace(ch = it.peek(0))) {
                if (ch == '-') {
                    this.tokens.add(new Token(Symbol.NOT, null));
                } else {
                    String litteral;
                    if (this.isLetterOrDigit(ch)) {
                        litteral = this.readLitteral(it);
                        this.tokens.add(new Token(Symbol.LITTERAL, litteral));
                        continue;
                    }
                    if (ch == '*') {
                        this.tokens.add(new Token(Symbol.REPETITION_SYMBOL, null));
                    } else {
                        if (ch == '(' && it.peek(1) == '*') {
                            String comment = this.readComment(it);
                            if (comment.trim().length() <= 0) continue;
                            this.tokens.add(new Token(Symbol.COMMENT_TOKEN, comment));
                            continue;
                        }
                        if (ch == ',') {
                            this.tokens.add(new Token(Symbol.CONCATENATION, null));
                        } else if (ch == '|') {
                            this.tokens.add(new Token(Symbol.ALTERNATION, null));
                        } else if (ch == '=') {
                            this.tokens.add(new Token(Symbol.DEFINITION, null));
                        } else if (ch == '(') {
                            this.tokens.add(new Token(Symbol.GROUPING_OPEN, null));
                        } else if (ch == ')') {
                            this.tokens.add(new Token(Symbol.GROUPING_CLOSE, null));
                        } else if (ch == '[') {
                            this.tokens.add(new Token(Symbol.OPTIONAL_OPEN, null));
                        } else if (ch == ']') {
                            this.tokens.add(new Token(Symbol.OPTIONAL_CLOSE, null));
                        } else if (ch == '{') {
                            this.tokens.add(new Token(Symbol.REPETITION_OPEN, null));
                        } else if (ch == '}' && it.peek(1) == '-') {
                            this.tokens.add(new Token(Symbol.REPETITION_MINUS_CLOSE, null));
                            it.jump();
                        } else if (ch == '}') {
                            this.tokens.add(new Token(Symbol.REPETITION_CLOSE, null));
                        } else {
                            if (ch == ';' || ch == '\u0000') break;
                            if (ch == '\"') {
                                litteral = this.readString(it);
                                this.tokens.add(new Token(Symbol.TERMINAL_STRING1, EbnfExpression.protect(litteral)));
                            } else if (ch == '\'') {
                                litteral = this.readString(it);
                                this.tokens.add(new Token(Symbol.TERMINAL_STRING2, EbnfExpression.protect(litteral)));
                            } else if (ch == '?') {
                                litteral = this.readString(it);
                                this.tokens.add(new Token(Symbol.SPECIAL_SEQUENCE, EbnfExpression.protect(litteral)));
                            } else {
                                this.tokens.clear();
                                return;
                            }
                        }
                    }
                }
            }
            it.jump();
        }
    }

    private static String protect(String litteral) {
        return litteral.length() == 0 ? " " : litteral;
    }

    @Override
    public TextBlock getUDrawable(ISkinParam skinParam) {
        Style style = ETile.getStyleSignature().getMergedStyle(skinParam.getCurrentStyleBuilder());
        FontConfiguration fc = style.getFontConfiguration(skinParam.getIHtmlColorSet());
        if (this.tokens.size() == 0) {
            return EbnfEngine.syntaxError(fc, skinParam);
        }
        try {
            TextBlock main;
            Iterator<Token> iterator = this.tokens.iterator();
            Token name = iterator.next();
            Token definition = iterator.next();
            if (definition.getSymbol() != Symbol.DEFINITION) {
                return EbnfEngine.syntaxError(fc, skinParam);
            }
            if (iterator.hasNext()) {
                List<Token> full = new ShuntingYard(iterator).getOuputQueue();
                if (full.size() == 0) {
                    return EbnfEngine.syntaxError(fc, skinParam);
                }
                main = this.getMainDrawing(skinParam, full.iterator());
            } else {
                HColor lineColor = style.value(PName.LineColor).asColor(skinParam.getIHtmlColorSet());
                main = new ETileWithCircles(new ETileEmpty(), lineColor);
            }
            TextBlock titleBox = new TitleBox(name.getData(), fc);
            if (this.commentAbove != null) {
                titleBox = TextBlockUtils.mergeTB(this.getNoteAbove(skinParam), titleBox, HorizontalAlignment.CENTER);
            }
            if (this.commentBelow != null) {
                titleBox = TextBlockUtils.mergeTB(titleBox, this.getNoteBelow(skinParam), HorizontalAlignment.CENTER);
            }
            return TextBlockUtils.mergeTB(titleBox, TextBlockUtils.withMargin(main, 0.0, 0.0, 10.0, 15.0), HorizontalAlignment.LEFT);
        }
        catch (Exception e) {
            e.printStackTrace();
            return EbnfEngine.syntaxError(fc, skinParam);
        }
    }

    private TextBlock getNoteAbove(ISkinParam skinParam) {
        if (this.commentAbove == null) {
            return null;
        }
        FloatingNote note = FloatingNote.create(Display.getWithNewlines(this.commentAbove), skinParam, SName.ebnf);
        return note;
    }

    private TextBlock getNoteBelow(ISkinParam skinParam) {
        if (this.commentBelow == null) {
            return null;
        }
        FloatingNote note = FloatingNote.create(Display.getWithNewlines(this.commentBelow), skinParam, SName.ebnf);
        return note;
    }

    private TextBlock getMainDrawing(ISkinParam skinParam, Iterator<Token> it) {
        EbnfEngine engine = new EbnfEngine(skinParam);
        while (it.hasNext()) {
            Token element = it.next();
            if (element.getSymbol() == Symbol.TERMINAL_STRING1 || element.getSymbol() == Symbol.TERMINAL_STRING2 || element.getSymbol() == Symbol.LITTERAL || element.getSymbol() == Symbol.SPECIAL_SEQUENCE) {
                engine.push(element);
                continue;
            }
            if (element.getSymbol() == Symbol.COMMENT_ABOVE) {
                engine.commentAbove(element.getData());
                continue;
            }
            if (element.getSymbol() == Symbol.COMMENT_BELOW) {
                engine.commentBelow(element.getData());
                continue;
            }
            if (element.getSymbol() == Symbol.ALTERNATION) {
                engine.alternation();
                continue;
            }
            if (element.getSymbol() == Symbol.CONCATENATION) {
                engine.concatenation();
                continue;
            }
            if (element.getSymbol() == Symbol.OPTIONAL) {
                engine.optional();
                continue;
            }
            if (element.getSymbol() == Symbol.NOT) {
                engine.not();
                continue;
            }
            if (element.getSymbol() == Symbol.REPETITION_ZERO_OR_MORE) {
                engine.repetitionZeroOrMore(this.isCompact);
                continue;
            }
            if (element.getSymbol() == Symbol.REPETITION_ONE_OR_MORE) {
                engine.repetitionOneOrMore();
                continue;
            }
            if (element.getSymbol() == Symbol.REPETITION_SYMBOL) {
                engine.repetitionSymbol();
                continue;
            }
            throw new UnsupportedOperationException(element.toString());
        }
        return engine.getTextBlock();
    }

    private String readString(CharInspector it) {
        char separator = it.peek(0);
        it.jump();
        StringBuilder sb = new StringBuilder();
        char ch;
        while ((ch = it.peek(0)) != separator) {
            sb.append(ch);
            it.jump();
        }
        return sb.toString();
    }

    private String readLitteral(CharInspector it) {
        StringBuilder sb = new StringBuilder();
        char ch;
        while (this.isLetterOrDigit(ch = it.peek(0))) {
            sb.append(ch);
            it.jump();
        }
        return sb.toString();
    }

    private String readComment(CharInspector it) {
        StringBuilder sb = new StringBuilder();
        it.jump();
        it.jump();
        char ch;
        while ((ch = it.peek(0)) != '\u0000') {
            if (ch == '*' && it.peek(1) == ')') {
                it.jump();
                it.jump();
                return sb.toString();
            }
            sb.append(ch);
            it.jump();
        }
        return sb.toString();
    }

    private boolean isLetterOrDigit(char ch) {
        return ch == '-' || ch == '_' || Character.isLetterOrDigit(ch);
    }

    public boolean isEmpty() {
        return this.tokens.size() == 0;
    }
}

