/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.filesdiagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.filesdiagram.FilesType;
import net.sourceforge.plantuml.klimt.LineBreakStrategy;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.CreoleMode;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.creole.Sheet;
import net.sourceforge.plantuml.klimt.creole.SheetBlock1;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.image.Opale;

public class FEntry
implements Iterable<FEntry> {
    private final FEntry parent;
    private final List<String> note;
    private final String name;
    private FilesType type;
    private List<FEntry> children = new ArrayList<FEntry>();

    public static FEntry createRoot() {
        return new FEntry(null, FilesType.FOLDER, "", null);
    }

    private FEntry(FEntry parent, FilesType type, String name, List<String> note) {
        this.parent = parent;
        this.note = note;
        this.name = name;
        this.type = type;
    }

    public FEntry addRawEntry(String raw) {
        int x = raw.indexOf(47);
        if (x == -1) {
            FEntry result = new FEntry(this, FilesType.DATA, raw, null);
            this.children.add(result);
            return result;
        }
        FEntry folder = this.getOrCreateFolder(raw.substring(0, x));
        String remain = raw.substring(x + 1);
        if (remain.length() != 0) {
            return folder.addRawEntry(remain);
        }
        return null;
    }

    public void addNote(List<String> note) {
        FEntry result = new FEntry(this, FilesType.NOTE, "NONE", note);
        this.children.add(result);
    }

    private FEntry getOrCreateFolder(String folderName) {
        for (FEntry child : this.children) {
            if (child.type != FilesType.FOLDER || !child.getName().equals(folderName)) continue;
            return child;
        }
        FEntry result = new FEntry(this, FilesType.FOLDER, folderName, null);
        this.children.add(result);
        return result;
    }

    @Override
    public Iterator<FEntry> iterator() {
        return Collections.unmodifiableCollection(this.children).iterator();
    }

    public FEntry getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public String getEmoticon() {
        if (this.type == FilesType.FOLDER) {
            return "<:1f4c2:>";
        }
        return "<:1f4c4:>";
    }

    public UGraphic drawAndMove(UGraphic ug, FontConfiguration fontConfiguration, ISkinParam skinParam, double deltax) {
        TextBlock result = this.getTextBlock(fontConfiguration, skinParam);
        result.drawU(ug.apply(UTranslate.dx(deltax)));
        ug = ug.apply(UTranslate.dy(result.calculateDimension(ug.getStringBounder()).getHeight() + 2.0));
        for (FEntry child : this.children) {
            ug = child.drawAndMove(ug, fontConfiguration, skinParam, deltax + 21.0);
        }
        return ug;
    }

    private TextBlock getTextBlock(FontConfiguration fontConfiguration, ISkinParam skinParam) {
        if (this.type == FilesType.NOTE) {
            return this.createOpale(skinParam);
        }
        Display display = Display.getWithNewlines(this.getEmoticon() + this.getName());
        TextBlock result = display.create7(fontConfiguration, HorizontalAlignment.LEFT, skinParam, CreoleMode.NO_CREOLE);
        return result;
    }

    private Opale createOpale(ISkinParam skinParam) {
        StyleSignatureBasic signature = StyleSignatureBasic.of(SName.root, SName.element, SName.filesDiagram, SName.note);
        Style style = signature.getMergedStyle(skinParam.getCurrentStyleBuilder());
        FontConfiguration fc = FontConfiguration.create(skinParam, style);
        double shadowing = style.value(PName.Shadowing).asDouble();
        HColor borderColor = style.value(PName.LineColor).asColor(skinParam.getIHtmlColorSet());
        HColor noteBackgroundColor = style.value(PName.BackGroundColor).asColor(skinParam.getIHtmlColorSet());
        UStroke stroke = style.getStroke();
        Sheet sheet = skinParam.sheet(fc, skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT), CreoleMode.FULL).createSheet(Display.create(this.note));
        SheetBlock1 sheet1 = new SheetBlock1(sheet, LineBreakStrategy.NONE, skinParam.getPadding());
        Opale opale = new Opale(shadowing, borderColor, noteBackgroundColor, sheet1, false, stroke);
        return opale;
    }
}

