/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.theme;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.text.StringLocated;

public class Theme {
    private final ReadLine source;
    private List<String> header;

    public Theme(ReadLine source) {
        this.source = source;
    }

    public StringLocated readLine() throws IOException {
        StringLocated line = this.source.readLine();
        if (this.header == null) {
            this.header = new ArrayList<String>();
            if (this.isSeparator(line)) {
                while ((line = this.source.readLine()) != null && !this.isSeparator(line)) {
                    this.header.add(line.getString());
                }
                line = this.source.readLine();
            }
        }
        return line;
    }

    private boolean isSeparator(StringLocated line) {
        return line.getString().equals("---");
    }

    public void close() throws IOException {
        this.source.close();
    }
}

