/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim.stdlib;

import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TFunctionSignature;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.expression.TValue;
import net.sourceforge.plantuml.tim.stdlib.SimpleReturnFunction;

public class RandomFunction
extends SimpleReturnFunction {
    private final Random random = new Random();

    @Override
    public TFunctionSignature getSignature() {
        return new TFunctionSignature("%random", 2);
    }

    @Override
    public boolean canCover(int nbArg, Set<String> namedArgument) {
        return nbArg == 0 || nbArg == 1 || nbArg == 2;
    }

    @Override
    public TValue executeReturnFunction(TContext context, TMemory memory, StringLocated location, List<TValue> values, Map<String, TValue> named) throws EaterException {
        switch (values.size()) {
            case 0: {
                return TValue.fromInt(this.random.nextInt(2));
            }
            case 1: {
                Integer mx = values.get(0).toInt();
                return TValue.fromInt(this.random.nextInt(mx));
            }
            case 2: {
                Integer min = values.get(0).toInt();
                Integer max = values.get(1).toInt();
                return TValue.fromInt(this.random.nextInt(max - min) + min);
            }
        }
        assert (false);
        throw new EaterException("Error on Random: Too many argument", location);
    }
}

