/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabel;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.rule.AbstractStatisticalJavaRule;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.stat.DataPoint;

public class SwitchDensityRule
extends AbstractStatisticalJavaRule {
    public SwitchDensityRule() {
        this.setProperty((PropertyDescriptor)MINIMUM_DESCRIPTOR, 10.0);
    }

    @Override
    public Object visit(ASTSwitchStatement node, Object data) {
        SwitchDensity oldData = null;
        if (data instanceof SwitchDensity) {
            oldData = (SwitchDensity)data;
        }
        SwitchDensity density = new SwitchDensity();
        node.childrenAccept(this, density);
        DataPoint point = new DataPoint();
        point.setNode((Node)node);
        point.setScore(density.getDensity());
        point.setMessage(this.getMessage());
        this.addDataPoint(point);
        if (data instanceof SwitchDensity) {
            ((SwitchDensity)data).addStatements(density.getStatementCount());
        }
        return oldData;
    }

    @Override
    public Object visit(ASTStatement statement, Object data) {
        if (data instanceof SwitchDensity) {
            ((SwitchDensity)data).addStatement();
        }
        statement.childrenAccept(this, data);
        return data;
    }

    @Override
    public Object visit(ASTSwitchLabel switchLabel, Object data) {
        if (data instanceof SwitchDensity) {
            ((SwitchDensity)data).addSwitchLabel();
        }
        switchLabel.childrenAccept(this, data);
        return data;
    }

    private static class SwitchDensity {
        private int labels = 0;
        private int stmts = 0;

        private SwitchDensity() {
        }

        public void addSwitchLabel() {
            ++this.labels;
        }

        public void addStatement() {
            ++this.stmts;
        }

        public void addStatements(int stmtCount) {
            this.stmts += stmtCount;
        }

        public int getStatementCount() {
            return this.stmts;
        }

        public double getDensity() {
            if (this.labels == 0) {
                return 0.0;
            }
            return (double)this.stmts / (double)this.labels;
        }
    }
}

