/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArrayDimensions;
import net.sourceforge.pmd.lang.java.ast.ASTArrayType;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTCatchParameter;
import net.sourceforge.pmd.lang.java.ast.ASTEnumConstant;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTForInit;
import net.sourceforge.pmd.lang.java.ast.ASTForeachStatement;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaParameter;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTModifierList;
import net.sourceforge.pmd.lang.java.ast.ASTPattern;
import net.sourceforge.pmd.lang.java.ast.ASTRecordComponent;
import net.sourceforge.pmd.lang.java.ast.ASTResource;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.AbstractTypedSymbolDeclarator;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaVisitor;
import net.sourceforge.pmd.lang.java.ast.ModifierOwner;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ASTVariableId
extends AbstractTypedSymbolDeclarator<JVariableSymbol>
implements ModifierOwner {
    private String name;
    private List<ASTAssignableExpr.ASTNamedReferenceExpr> usages = Collections.emptyList();

    ASTVariableId(int id) {
        super(id);
    }

    @Override
    protected <P, R> R acceptVisitor(JavaVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    public List<ASTAssignableExpr.ASTNamedReferenceExpr> getLocalUsages() {
        return this.usages;
    }

    void addUsage(ASTAssignableExpr.ASTNamedReferenceExpr usage) {
        if (this.usages.isEmpty()) {
            this.usages = new ArrayList<ASTAssignableExpr.ASTNamedReferenceExpr>(4);
        }
        this.usages.add(usage);
    }

    public @Nullable ASTArrayDimensions getExtraDimensions() {
        return (ASTArrayDimensions)this.children(ASTArrayDimensions.class).first();
    }

    @Override
    public @NonNull ASTModifierList getModifiers() {
        return this.getModifierOwnerParent().getModifiers();
    }

    public boolean isFinal() {
        return this.hasModifiers(JModifier.FINAL, new JModifier[0]);
    }

    public boolean isStatic() {
        return this.hasModifiers(JModifier.STATIC, new JModifier[0]);
    }

    @Override
    public ModifierOwner.Visibility getVisibility() {
        return this.isPatternBinding() ? ModifierOwner.Visibility.V_LOCAL : this.getModifierOwnerParent().getVisibility();
    }

    private ModifierOwner getModifierOwnerParent() {
        JavaNode parent = (JavaNode)this.getParent();
        if (parent instanceof ASTVariableDeclarator) {
            return (ModifierOwner)parent.getParent();
        }
        return (ModifierOwner)parent;
    }

    public boolean isUnnamed() {
        return "_".equals(this.name) && this.getLanguageVersion().compareToVersion("22") >= 0;
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public boolean hasArrayType() {
        return this.getExtraDimensions() != null || this.getTypeNode() instanceof ASTArrayType;
    }

    public boolean isExceptionBlockParameter() {
        return this.getParent() instanceof ASTCatchParameter;
    }

    public boolean isFormalParameter() {
        return this.getParent() instanceof ASTFormalParameter || this.isLambdaParameter();
    }

    public boolean isRecordComponent() {
        return this.getParent() instanceof ASTRecordComponent;
    }

    public boolean isLocalVariable() {
        return this.ancestors().get(1) instanceof ASTLocalVariableDeclaration && !this.isResourceDeclaration() && !this.isForeachVariable();
    }

    public boolean isForeachVariable() {
        return this.ancestors().get(2) instanceof ASTForeachStatement;
    }

    public boolean isForLoopVariable() {
        return this.ancestors().get(2) instanceof ASTForInit;
    }

    public boolean isLambdaParameter() {
        return this.getParent() instanceof ASTLambdaParameter;
    }

    public boolean isField() {
        return this.ancestors().get(1) instanceof ASTFieldDeclaration;
    }

    public boolean isEnumConstant() {
        return this.getParent() instanceof ASTEnumConstant;
    }

    public boolean isResourceDeclaration() {
        return ((JavaNode)((JavaNode)this.getParent()).getParent()).getParent() instanceof ASTResource;
    }

    public boolean isTypeInferred() {
        return this.getTypeNode() == null;
    }

    public boolean isPatternBinding() {
        return this.getParent() instanceof ASTPattern;
    }

    public @Nullable ASTExpression getInitializer() {
        if (this.getParent() instanceof ASTVariableDeclarator) {
            return ((ASTVariableDeclarator)this.getParent()).getInitializer();
        }
        return null;
    }

    public @Nullable Node getTypeNameNode() {
        return this.getTypeNode();
    }

    public @Nullable ASTType getTypeNode() {
        ModifierOwner parent = this.getModifierOwnerParent();
        return (ASTType)parent.firstChild(ASTType.class);
    }

    @Override
    public @NonNull JTypeMirror getTypeMirror() {
        return super.getTypeMirror();
    }
}

