/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTArrayAllocation;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.InvocationNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.types.JArrayType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.OverloadSelectionResult;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.TypePrettyPrint;

public class ConfusingArgumentToVarargsMethodRule
extends AbstractJavaRulechainRule {
    public ConfusingArgumentToVarargsMethodRule() {
        super(ASTArgumentList.class, new Class[0]);
    }

    public Object visit(ASTArgumentList argList, Object data) {
        if (argList.isEmpty()) {
            return null;
        }
        InvocationNode call = (InvocationNode)argList.getParent();
        OverloadSelectionResult info = call.getOverloadSelectionInfo();
        if (info.isFailed() || info.isVarargsCall() || !info.getMethodType().isVarargs()) {
            return null;
        }
        List<JTypeMirror> formals = info.getMethodType().getFormalParameters();
        JTypeMirror lastFormal = formals.get(formals.size() - 1);
        JTypeMirror expectedComponent = ((JArrayType)lastFormal).getComponentType();
        ASTExpression varargsArg = (ASTExpression)argList.getLastChild();
        assert (varargsArg != null);
        if (varargsArg.getTypeMirror().isSubtypeOf(expectedComponent) && !varargsArg.getTypeMirror().equals(lastFormal) && !TypeOps.isSpecialUnresolvedOrArray(varargsArg.getTypeMirror())) {
            String message = varargsArg instanceof ASTArrayAllocation && ((ASTArrayAllocation)varargsArg).getArrayInitializer() != null ? "Unclear if a varargs or non-varargs call is intended. Cast to {0} or {0}[], or pass varargs parameters separately to clarify intent." : "Unclear if a varargs or non-varargs call is intended. Cast to {0} or {0}[] to clarify intent.";
            this.asCtx(data).addViolationWithMessage((Node)varargsArg, message, new Object[]{TypePrettyPrint.prettyPrintWithSimpleNames(expectedComponent)});
        }
        return null;
    }
}

