/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeParameterOwnerSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeParameterSymbol;
import net.sourceforge.pmd.lang.java.symbols.internal.UnresolvedClassImpl;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class FlexibleUnresolvedClassImpl
extends UnresolvedClassImpl {
    private static final int UNKNOWN_ARITY = 0;
    private int arity = 0;
    private List<JTypeVar> tparams = Collections.emptyList();
    private List<UnresolvedClassImpl> childClasses = Collections.emptyList();

    FlexibleUnresolvedClassImpl(TypeSystem ts, @Nullable JClassSymbol enclosing, String canonicalName) {
        super(ts, enclosing, canonicalName);
    }

    @Override
    void setTypeParameterCount(int newArity) {
        if (this.arity == 0) {
            this.arity = newArity;
            ArrayList<JTypeVar> newParams = new ArrayList<JTypeVar>(newArity);
            for (int i = 0; i < newArity; ++i) {
                newParams.add(new FakeTypeParam("T" + i, this.getTypeSystem(), this).getTypeMirror());
            }
            this.tparams = Collections.unmodifiableList(newParams);
        }
    }

    @Override
    UnresolvedClassImpl getOrCreateUnresolvedChildClass(String simpleName) {
        if (this.childClasses.isEmpty()) {
            this.childClasses = new ArrayList<UnresolvedClassImpl>();
        }
        for (UnresolvedClassImpl childClass : this.childClasses) {
            if (!childClass.nameEquals(simpleName)) continue;
            return childClass;
        }
        FlexibleUnresolvedClassImpl newChild = new FlexibleUnresolvedClassImpl(this.getTypeSystem(), this, this.getCanonicalName() + '.' + simpleName);
        this.childClasses.add(newChild);
        return newChild;
    }

    @Override
    public List<JClassSymbol> getDeclaredClasses() {
        return Collections.unmodifiableList(this.childClasses);
    }

    @Override
    public List<JTypeVar> getTypeParameters() {
        return this.tparams;
    }

    private static final class FakeTypeParam
    implements JTypeParameterSymbol {
        private final String name;
        private final JTypeParameterOwnerSymbol owner;
        private final JTypeVar tvar;

        private FakeTypeParam(String name, TypeSystem ts, JTypeParameterOwnerSymbol owner) {
            this.name = name;
            this.owner = owner;
            this.tvar = ts.newTypeVar(this);
        }

        @Override
        public TypeSystem getTypeSystem() {
            return this.tvar.getTypeSystem();
        }

        @Override
        public JTypeVar getTypeMirror() {
            return this.tvar;
        }

        @Override
        public JTypeMirror computeUpperBound() {
            return this.getTypeSystem().OBJECT;
        }

        @Override
        public @NonNull String getSimpleName() {
            return this.name;
        }

        @Override
        public JTypeParameterOwnerSymbol getDeclaringSymbol() {
            return this.owner;
        }
    }
}

