/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.ast;

import net.sourceforge.pmd.lang.java.ast.InvocationNode;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.TypeConversion;
import net.sourceforge.pmd.lang.java.types.ast.internal.InvocCtx;
import net.sourceforge.pmd.lang.java.types.ast.internal.RegularCtx;
import net.sourceforge.pmd.util.AssertionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class ExprContext {
    protected final ExprContextKind kind;

    protected ExprContext(ExprContextKind kind) {
        this.kind = kind;
    }

    public abstract @Nullable JTypeMirror getTargetType();

    public boolean acceptsType(@NonNull JTypeMirror type) {
        AssertionUtil.requireParamNotNull((String)"type", (Object)type);
        JTypeMirror targetType = this.getTargetType();
        return targetType == null || (this.kind == ExprContextKind.CAST ? TypeConversion.isConvertibleInCastContext(type, targetType) : TypeConversion.isConvertibleUsingBoxing(type, targetType));
    }

    public boolean isMissing() {
        return this.kind == ExprContextKind.MISSING;
    }

    public ExprContextKind getKind() {
        return this.kind;
    }

    final boolean canGiveContextToPoly(boolean lambdaOrMethodRef) {
        return this.hasKind(ExprContextKind.ASSIGNMENT) || this.hasKind(ExprContextKind.INVOCATION) || this.hasKind(ExprContextKind.CAST) && lambdaOrMethodRef;
    }

    public @Nullable InvocationNode getInvocNodeIfInvocContext() {
        return this instanceof InvocCtx ? ((InvocCtx)this).getNode() : null;
    }

    public @NonNull ExprContext getToplevelCtx() {
        return this;
    }

    public @Nullable JTypeMirror getPolyTargetType(boolean lambdaOrMethodRef) {
        if (!this.canGiveContextToPoly(lambdaOrMethodRef)) {
            return null;
        }
        return this.getTargetType();
    }

    public static RegularCtx getMissingInstance() {
        return RegularCtx.NO_CTX;
    }

    public boolean hasKind(ExprContextKind kind) {
        return this.getKind() == kind;
    }

    public static enum ExprContextKind {
        INVOCATION,
        ASSIGNMENT,
        CAST,
        NUMERIC,
        STRING,
        TERNARY,
        MISSING,
        BOOLEAN;

    }
}

