/*
 * Decompiled with CFR 0.152.
 */
package nz.net.ultraq.thymeleaf.decorator;

import java.util.List;
import nz.net.ultraq.thymeleaf.LayoutUtilities;
import nz.net.ultraq.thymeleaf.decorator.XmlElementDecorator;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.dom.Text;

public class HtmlHeadDecorator
extends XmlElementDecorator {
    @Override
    public void decorate(Element decoratorhtml, Element contenthead) {
        Element decoratorhead = HtmlHeadDecorator.findElement(decoratorhtml, "head");
        if (decoratorhead == null) {
            if (contenthead != null) {
                decoratorhtml.insertChild(0, (Node)new Text(LayoutUtilities.LINE_SEPARATOR));
                decoratorhtml.insertChild(1, (Node)contenthead);
                Element contenttitle = HtmlHeadDecorator.findElement(contenthead, "title");
                if (contenttitle != null) {
                    Element resultingtitle = new Element("title");
                    HtmlHeadDecorator.extractTitle(contenthead, contenttitle, "title-pattern::content-title", resultingtitle);
                    contenthead.insertChild(0, (Node)new Text(LayoutUtilities.LINE_SEPARATOR));
                    contenthead.insertChild(1, (Node)resultingtitle);
                }
            }
            return;
        }
        Element decoratortitle = HtmlHeadDecorator.findElement(decoratorhead, "title");
        Element contenttitle = null;
        if (contenthead != null) {
            contenttitle = HtmlHeadDecorator.findElement(contenthead, "title");
        }
        Element resultingtitle = null;
        if (decoratortitle != null || contenttitle != null) {
            resultingtitle = new Element("title");
            if (decoratortitle != null) {
                HtmlHeadDecorator.extractTitle(decoratorhead, decoratortitle, "title-pattern::decorator-title", resultingtitle);
            }
            if (contenttitle != null) {
                HtmlHeadDecorator.extractTitle(contenthead, contenttitle, "title-pattern::content-title", resultingtitle);
            }
            if (LayoutUtilities.hasAttribute(resultingtitle, "layout", "title-pattern")) {
                LayoutUtilities.removeAttribute(resultingtitle, "th", "text");
                LayoutUtilities.removeAttribute(resultingtitle, "th", "utext");
            }
        }
        if (contenthead != null) {
            for (Node contentheadnode : contenthead.getChildren()) {
                if (contentheadnode instanceof Element) {
                    int insertionpoint = this.findBestInsertionPoint(decoratorhead, (Element)contentheadnode);
                    this.insertElementWithWhitespace(decoratorhead, (Element)contentheadnode, insertionpoint);
                    continue;
                }
                decoratorhead.addChild(contentheadnode);
            }
        }
        if (resultingtitle != null) {
            this.insertElementWithWhitespace(decoratorhead, resultingtitle, 0);
        }
        super.decorate(decoratorhead, contenthead);
    }

    private static void extractTitle(Element head, Element title, String titlekey, Element result) {
        Text titletext = (Text)title.getFirstChild();
        result.clearChildren();
        result.addChild((Node)titletext);
        if (LayoutUtilities.hasAttribute(title, "th", "utext")) {
            result.setNodeProperty(titlekey, (Object)LayoutUtilities.getAttributeValue(title, "th", "utext"));
        } else if (LayoutUtilities.hasAttribute(title, "th", "text")) {
            result.setNodeProperty(titlekey, (Object)LayoutUtilities.getAttributeValue(title, "th", "text"));
        } else if (title.hasNodeProperty(titlekey)) {
            result.setNodeProperty(titlekey, title.getNodeProperty(titlekey));
        } else if (titletext != null) {
            result.setNodeProperty(titlekey, (Object)titletext.getContent());
        }
        LayoutUtilities.pullAttributes(result, title);
        head.removeChild((Node)title);
    }

    private int findBestInsertionPoint(Element head, Element element) {
        HeadElement type = HeadElement.findMatchingType(element);
        int indexoflastoftype = -1;
        int indexoflastelement = -1;
        int indexoflastgap = -1;
        List headnodes = head.getChildren();
        for (int i = 0; i < headnodes.size(); ++i) {
            Node headnode = (Node)headnodes.get(i);
            if (headnode instanceof Element) {
                indexoflastelement = i;
                if (HeadElement.findMatchingType((Element)headnode) == type) {
                    indexoflastoftype = i;
                }
            }
            if (i != headnodes.size() - 1 || !(headnode instanceof Text)) continue;
            indexoflastgap = i;
        }
        return indexoflastoftype != -1 ? indexoflastoftype + 1 : (indexoflastelement != -1 ? indexoflastelement + 1 : (indexoflastgap != -1 ? indexoflastgap : headnodes.size()));
    }

    private void insertElementWithWhitespace(Element parent, Element child, int insertionpoint) {
        Node whitespace;
        List children = parent.getChildren();
        if (!children.isEmpty() && (whitespace = (Node)children.get(Math.min(insertionpoint, children.size() - 1))) instanceof Text) {
            parent.insertChild(insertionpoint, whitespace.cloneNode(null, false));
            parent.insertChild(insertionpoint + 1, (Node)child);
            return;
        }
        parent.insertChild(insertionpoint, (Node)child);
    }

    private static enum HeadElement {
        STYLESHEET,
        SCRIPT,
        OTHER;

        private static final String HEAD_ELEMENT_SCRIPT = "script";
        private static final String HEAD_ELEMENT_LINK = "link";
        private static final String HEAD_ELEMENT_STYLESHEET = "style";
        private static final String REL_ATTRIBUTE = "rel";
        private static final String REL_ATTRIBUTE_STYLESHEET = "stylesheet";

        private static HeadElement findMatchingType(Element element) {
            String elementname = element.getNormalizedName();
            if (elementname.equals(HEAD_ELEMENT_SCRIPT)) {
                return SCRIPT;
            }
            if (elementname.equals(HEAD_ELEMENT_STYLESHEET) || elementname.equals(HEAD_ELEMENT_LINK) && element.hasAttribute(REL_ATTRIBUTE) && element.getAttributeValue(REL_ATTRIBUTE).equals(REL_ATTRIBUTE_STYLESHEET)) {
                return STYLESHEET;
            }
            return OTHER;
        }
    }
}

