/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.administration;

import java.net.MalformedURLException;
import javax.jms.JMSException;
import org.exolab.core.util.URI;
import org.exolab.jms.administration.AdminConnection;
import org.exolab.jms.administration.JmsAdminServerIfc;
import org.exolab.jms.administration.http.HttpJmsAdminConnection;
import org.exolab.jms.administration.http.SslHttpJmsAdminConnection;
import org.exolab.jms.administration.intravm.IntravmJmsAdminConnection;
import org.exolab.jms.administration.mipc.IpcJmsAdminConnection;
import org.exolab.jms.administration.mipc.SslIpcJmsAdminConnection;
import org.exolab.jms.administration.rmi.RmiJmsAdminConnection;
import org.exolab.jms.config.types.SchemeType;

public class AdminConnectionFactory {
    private static AdminConnection getConnection(String url, String username, String password) throws JMSException, MalformedURLException {
        AdminConnection result = null;
        URI parser = null;
        try {
            parser = new URI(url);
        }
        catch (URI.MalformedURIException exception) {
            throw new MalformedURLException(exception.getMessage());
        }
        String protocol = parser.getScheme();
        String host = parser.getHost();
        int port = parser.getPort();
        String path = parser.getPath();
        if (host != null && host.trim().length() == 0) {
            host = null;
        }
        if (path != null) {
            if (path.trim().length() == 0) {
                path = null;
            } else if (path.startsWith("/") && (path = path.substring(1)).length() == 0) {
                path = null;
            }
        }
        SchemeType scheme = null;
        try {
            scheme = SchemeType.valueOf(protocol);
        }
        catch (IllegalArgumentException exception) {
            throw new MalformedURLException("Invalid scheme: " + protocol);
        }
        switch (scheme.getType()) {
            case 0: 
            case 1: {
                if (host != null && port != -1 && path == null) break;
                throw new MalformedURLException("Invalid URL: " + url);
            }
            case 2: 
            case 3: 
            case 4: {
                if (host != null && port != -1) break;
                throw new MalformedURLException("Invalid URL: " + url);
            }
            case 5: {
                if (host == null && port == -1 && path == null) break;
                throw new MalformedURLException("Invalid URL: " + url);
            }
        }
        switch (scheme.getType()) {
            case 0: {
                result = new IpcJmsAdminConnection(host, port, username, password);
                break;
            }
            case 1: {
                result = new SslIpcJmsAdminConnection(host, port, username, password);
                break;
            }
            case 4: {
                result = new RmiJmsAdminConnection(host, port, path, username, password);
                break;
            }
            case 2: {
                result = new HttpJmsAdminConnection(host, port, path, username, password);
                break;
            }
            case 3: {
                result = new SslHttpJmsAdminConnection(host, port, path, username, password);
                break;
            }
            case 5: {
                result = new IntravmJmsAdminConnection(username, password);
            }
        }
        return result;
    }

    public static JmsAdminServerIfc create(String url) throws JMSException, MalformedURLException {
        return AdminConnectionFactory.create(url, null, null);
    }

    public static JmsAdminServerIfc create(String url, String username, String password) throws JMSException, MalformedURLException {
        AdminConnection result = null;
        URI parser = null;
        try {
            parser = new URI(url);
        }
        catch (URI.MalformedURIException exception) {
            throw new MalformedURLException(exception.getMessage());
        }
        String protocol = parser.getScheme();
        String host = parser.getHost();
        int port = parser.getPort();
        String path = parser.getPath();
        if (host != null && host.trim().length() == 0) {
            host = null;
        }
        if (path != null) {
            if (path.trim().length() == 0) {
                path = null;
            } else if (path.startsWith("/") && (path = path.substring(1)).length() == 0) {
                path = null;
            }
        }
        SchemeType scheme = null;
        try {
            scheme = SchemeType.valueOf(protocol);
        }
        catch (IllegalArgumentException exception) {
            throw new MalformedURLException("Invalid scheme: " + protocol);
        }
        switch (scheme.getType()) {
            case 0: 
            case 1: {
                if (host != null && port != -1 && path == null) break;
                throw new MalformedURLException("Invalid URL: " + url);
            }
            case 2: 
            case 3: 
            case 4: {
                if (host != null && port != -1) break;
                throw new MalformedURLException("Invalid URL: " + url);
            }
            case 5: {
                if (host == null && port == -1 && path == null) break;
                throw new MalformedURLException("Invalid URL: " + url);
            }
        }
        switch (scheme.getType()) {
            case 0: {
                result = new IpcJmsAdminConnection(host, port, username, password);
                break;
            }
            case 1: {
                result = new SslIpcJmsAdminConnection(host, port, username, password);
                break;
            }
            case 4: {
                result = new RmiJmsAdminConnection(host, port, path, username, password);
                break;
            }
            case 2: {
                result = new HttpJmsAdminConnection(host, port, path, username, password);
                break;
            }
            case 3: {
                result = new SslHttpJmsAdminConnection(host, port, path, username, password);
                break;
            }
            case 5: {
                result = new IntravmJmsAdminConnection(username, password);
            }
        }
        return result;
    }
}

