/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsSession;
import org.exolab.jms.message.MessageImpl;

abstract class JmsMessageConsumer
implements MessageListener,
MessageConsumer {
    private MessageListener _messageListener = null;
    private JmsSession _session = null;
    private String _selector = null;
    private volatile boolean _closed = false;
    private long _clientId = -1L;
    private long _listenerSetTimestamp = 0L;
    private String _lastMessageDelivered;
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$client$JmsMessageConsumer == null ? (class$org$exolab$jms$client$JmsMessageConsumer = JmsMessageConsumer.class$("org.exolab.jms.client.JmsMessageConsumer")) : class$org$exolab$jms$client$JmsMessageConsumer));
    static /* synthetic */ Class class$org$exolab$jms$client$JmsMessageConsumer;

    public JmsMessageConsumer(JmsSession session, long clientId, String selector) {
        if (session == null) {
            throw new IllegalArgumentException("Argument 'session' is null");
        }
        this._session = session;
        this._clientId = clientId;
        this._selector = selector;
    }

    public long getClientId() {
        return this._clientId;
    }

    public String getMessageSelector() {
        return this._selector;
    }

    public MessageListener getMessageListener() {
        return this._messageListener;
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        if (listener != null) {
            if (this._messageListener == null) {
                this._listenerSetTimestamp = System.currentTimeMillis();
                this._messageListener = listener;
                this._session.setMessageListener(this);
            } else {
                this._messageListener = listener;
            }
        } else if (this._messageListener != null) {
            this._session.removeMessageListener(this);
            this._messageListener = listener;
        }
        this._lastMessageDelivered = null;
    }

    public Message receive() throws JMSException {
        return this.retrieveMessage(0L);
    }

    public Message receive(long timeout) throws JMSException {
        return this.retrieveMessage(timeout);
    }

    public Message receiveNoWait() throws JMSException {
        return this.retrieveMessage(-1L);
    }

    public synchronized void close() throws JMSException {
        this._closed = true;
        this.notifyAll();
        this._messageListener = null;
        this._session = null;
        this._selector = null;
    }

    public synchronized void destroy() throws JMSException {
        this._closed = true;
        this.notifyAll();
        this._messageListener = null;
        this._session = null;
        this._selector = null;
    }

    public synchronized void onMessage(Message message) {
        try {
            if (this._messageListener != null) {
                long rcvd = message.getLongProperty("JMSXRcvTimestamp");
                if (rcvd < this._listenerSetTimestamp) {
                    return;
                }
                this._lastMessageDelivered = ((MessageImpl)message).getId();
                this._messageListener.onMessage(message);
            }
        }
        catch (JMSException exception) {
            _log.error((Object)"Error in onMessage", (Throwable)exception);
        }
    }

    public Message retrieveMessage(long wait) throws JMSException {
        if (this._messageListener != null) {
            throw new JMSException("Can't receive when listener defined");
        }
        if (this._closed) {
            throw new JMSException("Can't receive when session closed");
        }
        MessageImpl message = (MessageImpl)this._session.retrieveMessage(this._clientId, wait);
        if (message != null) {
            this._lastMessageDelivered = message.getId();
        }
        return message;
    }

    public String getLastMessageDelivered() {
        return this._lastMessageDelivered;
    }

    public boolean isClosed() {
        return this._closed;
    }

    protected JmsSession getSession() {
        return this._session;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

