/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client;

import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Vector;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsMessageConsumer;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsQueueSession;

class JmsQueueBrowser
extends JmsMessageConsumer
implements QueueBrowser,
Enumeration {
    private JmsQueue _queue = null;
    private LinkedList _messages = new LinkedList();
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$client$JmsQueueBrowser == null ? (class$org$exolab$jms$client$JmsQueueBrowser = JmsQueueBrowser.class$("org.exolab.jms.client.JmsQueueBrowser")) : class$org$exolab$jms$client$JmsQueueBrowser));
    static /* synthetic */ Class class$org$exolab$jms$client$JmsQueueBrowser;

    public JmsQueueBrowser(JmsQueueSession session, long clientId, JmsQueue queue, String selector) throws InvalidDestinationException {
        super(session, clientId, selector);
        if (queue == null) {
            throw new InvalidDestinationException("Argument 'queue' is null");
        }
        this._queue = queue;
    }

    public Queue getQueue() {
        return this._queue;
    }

    public Enumeration getEnumeration() {
        return this;
    }

    public void close() throws JMSException {
        if (!this.isClosed()) {
            JmsQueueSession session = (JmsQueueSession)this.getSession();
            session.removeBrowser(this);
            this._queue = null;
            this._messages.clear();
            this._messages = null;
            super.close();
        }
    }

    public synchronized void destroy() throws JMSException {
        this._queue = null;
        this._messages.clear();
        this._messages = null;
        super.destroy();
    }

    public void onMessage(Message message) {
        throw new RuntimeException("JmsQueueBrowsder.onMessage() has been called");
    }

    public boolean hasMoreElements() {
        return !this.isEmpty();
    }

    public synchronized Object nextElement() {
        if (!this.isEmpty()) {
            return this._messages.removeFirst();
        }
        return null;
    }

    private boolean isEmpty() {
        int count = 20;
        if (!this._messages.isEmpty()) {
            return false;
        }
        Vector messages = null;
        try {
            messages = this.getSession().retrieveMessages(this.getClientId(), 20);
        }
        catch (JMSException exception) {
            _log.error((Object)"Error in JmsQueueBrowser.isEmpty", (Throwable)exception);
        }
        if (messages != null && messages.size() > 0) {
            while (messages.size() > 0) {
                this._messages.addLast(messages.remove(0));
            }
        }
        return this._messages.isEmpty();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

