/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueSender;
import org.exolab.jms.client.JmsMessageProducer;
import org.exolab.jms.client.JmsQueue;
import org.exolab.jms.client.JmsQueueSession;
import org.exolab.jms.client.JmsSession;

class JmsQueueSender
extends JmsMessageProducer
implements QueueSender {
    private JmsQueue _queue = null;

    public JmsQueueSender(JmsSession session, JmsQueue queue) {
        super(session);
        this._queue = queue;
    }

    public Queue getQueue() {
        return this._queue;
    }

    public void send(Message message) throws JMSException {
        this.send(this.getQueue(), message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.send(this.getQueue(), message, deliveryMode, priority, timeToLive);
    }

    public void send(Queue queue, Message message) throws JMSException {
        this.send(queue, message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
    }

    public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.sendMessage((Destination)queue, message, deliveryMode, priority, timeToLive);
    }

    public synchronized void close() throws JMSException {
        if (!this.isClosed()) {
            JmsQueueSession session = (JmsQueueSession)this.getSession();
            session.removeSender(this);
            super.close();
        }
    }

    public void destroy() {
        super.destroy();
        this._queue = null;
    }
}

