/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client.mipc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.jms.Message;
import org.exolab.core.mipc.MultiplexConnectionIfc;
import org.exolab.core.mipc.ObjectChannel;
import org.exolab.jms.client.JmsMessageListener;

class IpcJmsMessageListener
implements Runnable {
    private Map _listeners = Collections.synchronizedMap(new HashMap(10));
    private ObjectChannel _channel;
    private Thread _thread;
    private boolean _interrupted = false;
    private final Object _lock = new Object();

    public IpcJmsMessageListener(MultiplexConnectionIfc connection) {
        if (connection == null) {
            throw new IllegalArgumentException("Argument 'connection' is null");
        }
        MultiplexConnectionIfc multiplexConnectionIfc = connection;
        synchronized (multiplexConnectionIfc) {
            this._channel = new ObjectChannel("message", connection);
        }
    }

    public void setListener(String sessionId, JmsMessageListener listener) {
        this._listeners.put(sessionId, listener);
    }

    public void closeSession(String sessionId) {
        this._listeners.remove(sessionId);
    }

    public void closeAllSessions() {
        this._listeners.clear();
    }

    public void onMessage(String sessionId, Message message) {
        JmsMessageListener listener = (JmsMessageListener)this._listeners.get(sessionId);
        if (listener != null) {
            listener.onMessage(message);
        }
    }

    public void onMessages(String sessionId, Vector messages) {
        JmsMessageListener listener = (JmsMessageListener)this._listeners.get(sessionId);
        if (listener != null) {
            listener.onMessages(messages);
        }
    }

    public void onMessageAvailable(String sessionId, long clientId) {
        JmsMessageListener listener = (JmsMessageListener)this._listeners.get(sessionId);
        if (listener != null) {
            listener.onMessageAvailable(clientId);
        }
    }

    public void start() {
        Object object = this._lock;
        synchronized (object) {
            if (this._thread == null) {
                this._interrupted = false;
                this._thread = new Thread(this);
                this._thread.start();
            }
        }
    }

    public void stop() {
        this.closeAllSessions();
        Object object = this._lock;
        synchronized (object) {
            if (this._thread != null) {
                this._interrupted = true;
                this._thread.interrupt();
            }
        }
    }

    /*
     * Loose catch block
     */
    public void run() {
        while (!this._interrupted) {
            Vector v = (Vector)this._channel.receive();
            String sessionId = (String)v.get(0);
            if (v.get(1) instanceof Message) {
                this.onMessage(sessionId, (Message)v.get(1));
            } else if (v.get(1) instanceof Vector) {
                this.onMessages(sessionId, (Vector)v.get(1));
            } else if (v.get(1) instanceof Long) {
                this.onMessageAvailable(sessionId, (Long)v.get(1));
            }
            this._channel.send(new Vector());
        }
        Object var4_4 = null;
        try {
            this._channel.close();
        }
        catch (Exception ignore2) {
            // empty catch block
        }
        Object object = this._lock;
        synchronized (object) {
            this._thread = null;
        }
        {
            catch (Exception ignore) {
                Object var4_5 = null;
                try {
                    this._channel.close();
                }
                catch (Exception ignore2) {
                    // empty catch block
                }
                Object object2 = this._lock;
                synchronized (object2) {
                    this._thread = null;
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            try {
                this._channel.close();
            }
            catch (Exception ignore2) {
                // empty catch block
            }
            Object object3 = this._lock;
            synchronized (object3) {
                this._thread = null;
            }
            throw throwable;
        }
    }
}

