/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.client.rmi;

import java.rmi.ConnectException;
import java.rmi.RemoteException;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.jms.client.JmsConnectionStubIfc;
import org.exolab.jms.client.JmsSessionStubIfc;
import org.exolab.jms.client.rmi.RmiJmsServerStub;
import org.exolab.jms.client.rmi.RmiJmsSessionStub;
import org.exolab.jms.server.rmi.RemoteJmsServerConnectionIfc;
import org.exolab.jms.server.rmi.RemoteJmsServerSessionIfc;

public class RmiJmsConnectionStub
implements JmsConnectionStubIfc {
    protected volatile RemoteJmsServerConnectionIfc _delegate = null;
    protected RmiJmsServerStub _owner = null;
    private PingThread _pinger = null;
    public final String MAX_RETRY_PROP = "org.exolab.jms.rmi.retryCount";
    public final String RETRY_INTERVAL_PROP = "org.exolab.jms.rmi.retryInterval";
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$client$rmi$RmiJmsConnectionStub == null ? (class$org$exolab$jms$client$rmi$RmiJmsConnectionStub = RmiJmsConnectionStub.class$("org.exolab.jms.client.rmi.RmiJmsConnectionStub")) : class$org$exolab$jms$client$rmi$RmiJmsConnectionStub));
    static /* synthetic */ Class class$org$exolab$jms$client$rmi$RmiJmsConnectionStub;

    public RmiJmsConnectionStub(RemoteJmsServerConnectionIfc connection, int pingInterval, RmiJmsServerStub server) throws JMSException {
        if (connection != null) {
            this._owner = server;
            this._delegate = connection;
            if (pingInterval > 0) {
                this._pinger = new PingThread(pingInterval);
                this._pinger.start();
            }
        } else {
            throw new JMSException("Cannot instantiate with a null connection");
        }
    }

    public JmsSessionStubIfc createSession(int ackMode, boolean transacted) throws JMSException {
        RmiJmsSessionStub stub = null;
        try {
            RemoteJmsServerSessionIfc session = this._delegate.createSession(ackMode, transacted);
            stub = new RmiJmsSessionStub(session);
            session.setMessageListener(stub);
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to createSession  " + exception);
        }
        return stub;
    }

    public void close() throws JMSException {
        if (this._pinger != null) {
            this._pinger.close();
        }
        try {
            this._delegate.close();
            this._delegate = null;
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to close  " + exception);
        }
    }

    public String getConnectionId() throws JMSException {
        try {
            return this._delegate.getConnectionId();
        }
        catch (RemoteException exception) {
            throw new JMSException("Failed to getConnectionId  " + exception);
        }
    }

    public void destroy() {
        if (this._pinger != null) {
            this._pinger.close();
        }
        this._delegate = null;
        this._owner = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PingThread
    extends Thread {
        private int _interval;
        private int _retries;
        private int _retryInterval;
        private volatile boolean _stop = false;

        PingThread(int interval) {
            this._interval = interval;
            this.setName("PingThread-" + Math.abs(this.hashCode()));
            this.setDaemon(true);
            this._retries = this.getProperty("org.exolab.jms.rmi.retryCount", 10, 1);
            this._retryInterval = this.getProperty("org.exolab.jms.rmi.retryInterval", 100, 100);
        }

        public void run() {
            while (!this._stop) {
                if (this.ping()) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(this._interval * 1000);
                    }
                    catch (InterruptedException ignore) {}
                    continue;
                }
                try {
                    JMSException error = new JMSException("Connection to server terminated", "connection_to_server_dropped");
                    _log.warn((Object)"Server is not responding. Generating onException", (Throwable)error);
                    RmiJmsConnectionStub.this._owner.getExceptionListener().onException(error);
                }
                catch (Throwable throwable) {}
                break;
            }
        }

        public void close() {
            this._stop = true;
            try {
                this.interrupt();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }

        private boolean ping() {
            boolean successful = false;
            RemoteJmsServerConnectionIfc delegate = RmiJmsConnectionStub.this._delegate;
            if (delegate != null) {
                int count = 0;
                while (count < this._retries && !successful && !this._stop) {
                    try {
                        delegate.ping();
                        successful = true;
                    }
                    catch (RemoteException exception) {
                        _log.warn((Object)("Failed to ping openjms server. Retry count=" + count), (Throwable)exception);
                        if (exception.detail instanceof ConnectException && count < this._retries - 1) {
                            try {
                                Thread.sleep(this._retryInterval);
                            }
                            catch (InterruptedException ignore) {}
                        }
                    }
                    catch (Throwable exception) {
                        _log.warn((Object)"Exception pinging server", exception);
                    }
                    ++count;
                }
            }
            return successful;
        }

        private int getProperty(String name, int defaultValue, int minimum) {
            int result = defaultValue;
            String value = null;
            try {
                value = System.getProperty(name);
            }
            catch (SecurityException ignore) {
                // empty catch block
            }
            if (value != null) {
                try {
                    result = Integer.parseInt(value);
                    if (result <= minimum) {
                        result = minimum;
                    }
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
            return result;
        }
    }
}

