/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.config;

import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.exolab.castor.xml.EventProducer;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.jms.config.AttributeExpander;
import org.exolab.jms.config.Configuration;
import org.exolab.jms.config.DefaultConfiguration;
import org.exolab.jms.config.JndiConfigurationFactory;

public class ConfigurationLoader {
    private static final String DEFAULT_CONFIG = "/org/exolab/jms/config/openjms_defaults.xml";
    static /* synthetic */ Class class$org$exolab$jms$config$Configuration;
    static /* synthetic */ Class class$org$exolab$jms$config$DefaultConfiguration;

    public Configuration load(String path) throws IOException, MarshalException, ValidationException {
        Configuration result = null;
        FileReader reader = new FileReader(path);
        try {
            Unmarshaller stream = new Unmarshaller(class$org$exolab$jms$config$Configuration == null ? (class$org$exolab$jms$config$Configuration = ConfigurationLoader.class$("org.exolab.jms.config.Configuration")) : class$org$exolab$jms$config$Configuration);
            AttributeExpander handler = new AttributeExpander(reader);
            result = (Configuration)stream.unmarshal((EventProducer)handler);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            reader.close();
            throw throwable;
        }
        reader.close();
        return this.load(result);
    }

    public Configuration load(Configuration config) throws IOException, MarshalException, ValidationException {
        DefaultConfiguration defaults = this.getDefaults();
        if (config.getServerConfiguration() == null) {
            config.setServerConfiguration(defaults.getServerConfiguration());
        }
        if (config.getConnectors() == null) {
            config.setConnectors(defaults.getConnectors());
        }
        if (config.getLoggerConfiguration() == null) {
            config.setLoggerConfiguration(defaults.getLoggerConfiguration());
        }
        if (config.getTcpConfiguration() == null) {
            config.setTcpConfiguration(defaults.getTcpConfiguration());
        }
        if (config.getTcpsConfiguration() == null) {
            config.setTcpsConfiguration(defaults.getTcpsConfiguration());
        }
        if (config.getRmiConfiguration() == null) {
            config.setRmiConfiguration(defaults.getRmiConfiguration());
        }
        if (config.getHttpConfiguration() == null) {
            config.setHttpConfiguration(defaults.getHttpConfiguration());
        }
        if (config.getHttpsConfiguration() == null) {
            config.setHttpsConfiguration(defaults.getHttpsConfiguration());
        }
        if (config.getMessageManagerConfiguration() == null) {
            config.setMessageManagerConfiguration(defaults.getMessageManagerConfiguration());
        }
        if (config.getSchedulerConfiguration() == null) {
            config.setSchedulerConfiguration(defaults.getSchedulerConfiguration());
        }
        if (config.getGarbageCollectionConfiguration() == null) {
            config.setGarbageCollectionConfiguration(defaults.getGarbageCollectionConfiguration());
        }
        if (config.getSecurityConfiguration() == null) {
            config.setSecurityConfiguration(defaults.getSecurityConfiguration());
        }
        if (config.getServerConfiguration().getEmbeddedJNDI()) {
            config.setJndiConfiguration(JndiConfigurationFactory.create(config));
        } else if (config.getJndiConfiguration() == null) {
            throw new ValidationException("JndiConfiguration must be provided when ServerConfiguation/embeddedJNDI is true");
        }
        return config;
    }

    private DefaultConfiguration getDefaults() throws IOException, MarshalException, ValidationException {
        DefaultConfiguration result = null;
        InputStream source = this.getClass().getResourceAsStream(DEFAULT_CONFIG);
        if (source == null) {
            throw new IOException("Failed to find default configuration: /org/exolab/jms/config/openjms_defaults.xml");
        }
        try {
            Unmarshaller stream = new Unmarshaller(class$org$exolab$jms$config$DefaultConfiguration == null ? (class$org$exolab$jms$config$DefaultConfiguration = ConfigurationLoader.class$("org.exolab.jms.config.DefaultConfiguration")) : class$org$exolab$jms$config$DefaultConfiguration);
            AttributeExpander handler = new AttributeExpander(new InputStreamReader(source));
            result = (DefaultConfiguration)stream.unmarshal((EventProducer)handler);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                source.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            source.close();
        }
        catch (IOException ignore) {}
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

