/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.jms.jndi.http;

import java.util.Hashtable;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.spi.InitialContextFactory;
import org.apache.avalon.excalibur.naming.DefaultNamespace;
import org.apache.avalon.excalibur.naming.RemoteContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.core.http.HttpClient;
import org.exolab.core.util.URI;
import org.exolab.jms.jndi.http.NameServiceProxy;

public class HttpJndiInitialContextFactory
implements InitialContextFactory {
    protected static final String SERVLET = "openjms/OpenJMSJndi";
    private static final String HTTP_SCHEME = "http";
    private static final Log _log = LogFactory.getLog((Class)(class$org$exolab$jms$jndi$http$HttpJndiInitialContextFactory == null ? (class$org$exolab$jms$jndi$http$HttpJndiInitialContextFactory = HttpJndiInitialContextFactory.class$("org.exolab.jms.jndi.http.HttpJndiInitialContextFactory")) : class$org$exolab$jms$jndi$http$HttpJndiInitialContextFactory));
    static /* synthetic */ Class class$org$exolab$jms$jndi$http$HttpJndiInitialContextFactory;

    public Context getInitialContext(Hashtable environment) throws NamingException {
        NameParser parser;
        Object context = null;
        String url = this.getProviderURL(environment);
        HttpClient connection = this.openConnection(url);
        NameServiceProxy provider = new NameServiceProxy(connection);
        try {
            parser = provider.getNameParser();
        }
        catch (NamingException exception) {
            throw exception;
        }
        catch (Exception exception) {
            ServiceUnavailableException error = new ServiceUnavailableException(exception.getMessage());
            error.setRootCause(exception);
            throw error;
        }
        DefaultNamespace namespace = new DefaultNamespace(parser);
        Hashtable<String, Object> env = new Hashtable<String, Object>(environment);
        env.put("org.apache.avalon.excalibur.naming.NamingProvider", provider);
        env.put("org.apache.avalon.excalibur.naming.Namespace", namespace);
        return new RemoteContext(env, parser.parse(""));
    }

    protected String getProviderURL(Hashtable environment) throws NamingException {
        if (environment == null) {
            throw new ConfigurationException("Cannot connect to JNDI provider - environment not set");
        }
        String url = (String)environment.get("java.naming.provider.url");
        if (url != null) {
            URI uri;
            try {
                uri = new URI(url);
            }
            catch (URI.MalformedURIException exception) {
                throw new ConfigurationException("Malformed JNDI provider URL: " + url);
            }
            if (!HTTP_SCHEME.equals(uri.getScheme())) {
                throw new ConfigurationException("URL=" + url + " has an invalid scheme");
            }
            String path = uri.getPath();
            if (path == null || path.length() == 0) {
                url = url + "/openjms/OpenJMSJndi";
            } else if (path.equals("/")) {
                url = url + SERVLET;
            }
        } else {
            url = this.getDeprecatedEnvironment(environment);
        }
        return url;
    }

    protected HttpClient openConnection(String url) throws NamingException {
        HttpClient client;
        try {
            client = new HttpClient(url, "HttpJndiInitialContextFactory");
        }
        catch (Exception exception) {
            NamingException error = new NamingException("Failed to connect to JNDI provider");
            error.setRootCause(exception);
            throw error;
        }
        return client;
    }

    private String getDeprecatedEnvironment(Hashtable environment) {
        _log.warn((Object)(this.getClass().getName() + ": using deprecated environment. Use Context.PROVIDER_URL"));
        StringBuffer url = new StringBuffer(HTTP_SCHEME);
        String host = (String)environment.get("org.exolab.jms.jndi.host");
        Integer port = (Integer)environment.get("org.exolab.jms.jndi.port");
        if (host != null) {
            url.append(host);
        } else {
            url.append("localhost");
        }
        if (port != null) {
            url.append(":");
            url.append(port.toString());
        }
        url.append("/");
        url.append(SERVLET);
        return url.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

